/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;

public class WalletKudosService {
    private SettingService settingService;
    Double budget;
    private String kudosContractAddress;

    public WalletKudosService(SettingService settingService) {
        this.settingService = settingService;
    }

    public double getKudosBudget() {
        if (this.budget == null) {
            SettingValue value = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_BUDGET");
            this.budget = value == null ? 0.0 : Double.parseDouble(value.getValue().toString());
        }
        return this.budget;
    }

    public String getKudosContract() {
        if (this.kudosContractAddress == null) {
            SettingValue value = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_CONTRACT_ADDRESS");
            this.kudosContractAddress = value == null ? "" : value.getValue().toString();
        }
        return this.kudosContractAddress;
    }

    public void saveKudosTotalBudget(double budget) {
        this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_BUDGET", SettingValue.create((Double)budget));
        this.budget = null;
    }

    public void saveKudosContract(String kudosContractAddress) {
        this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "KUDOS_CONTRACT_ADDRESS", SettingValue.create((String)kudosContractAddress));
        this.kudosContractAddress = null;
    }
}

