/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.model.ApplicationType;
import org.picocontainer.Startable;

public class SetupApplicationRegistryService
implements Startable {
    private static final List<String> EVERYONE_PERMISSION_LIST = Collections.singletonList("Everyone");
    private static final String WALLET_CATEGORY_NAME = "EthereumWallet";
    private ExoContainer container;
    private ApplicationRegistryService applicationRegistryService;

    public SetupApplicationRegistryService(ExoContainer container, ApplicationRegistryService applicationRegistryService) {
        this.container = container;
        this.applicationRegistryService = applicationRegistryService;
    }

    public void start() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ApplicationCategory applicationCategory = this.applicationRegistryService.getApplicationCategory(WALLET_CATEGORY_NAME);
            if (applicationCategory == null) {
                applicationCategory = new ApplicationCategory();
                applicationCategory.setAccessPermissions(EVERYONE_PERMISSION_LIST);
                applicationCategory.setName(WALLET_CATEGORY_NAME);
                applicationCategory.setDescription("Ethereum Wallet");
                applicationCategory.setDisplayName("Ethereum Wallet");
                Application application = new Application();
                applicationCategory.setApplications(Collections.singletonList(application));
                application.setAccessPermissions(new ArrayList<String>(EVERYONE_PERMISSION_LIST));
                application.setDisplayName("Ethereum Space Wallet");
                application.setDescription("Ethereum Space Wallet");
                application.setApplicationName("EthereumSpaceWallet");
                application.setCategoryName(WALLET_CATEGORY_NAME);
                application.setContentId("exo-ethereum-wallet/EthereumSpaceWallet");
                application.setType(ApplicationType.PORTLET);
                this.applicationRegistryService.save(applicationCategory);
                this.applicationRegistryService.save(applicationCategory, application);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }
}

