// Generated by delombok at Fri Jan 04 08:52:45 UTC 2019
package org.exoplatform.addon.ethereum.wallet.ext.gamification.model;

import static org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils.*;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardPeriodType;
import org.exoplatform.ws.frameworks.json.impl.*;

public class GamificationSettings implements Serializable {
  public static final long serialVersionUID = 2416168589742260549L;
  private long threshold;
  private String contractAddress;
  private RewardPeriodType periodType = RewardPeriodType.DEFAULT;
  private GamificationRewardType rewardType = GamificationRewardType.FIXED;
  private double totalBudget;
  private double budgetPerMember;

  public static GamificationSettings fromString(String value) throws JsonException {
    if (StringUtils.isBlank(value)) {
      return null;
    }
    JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
    JSON_PARSER.parse(new ByteArrayInputStream(value.getBytes()), jsonDefaultHandler);
    return ObjectBuilder.createObject(GamificationSettings.class, jsonDefaultHandler.getJsonObject());
  }

  public String toStringToStore() {
    try {
      return JSON_GENERATOR.createJsonObject(this).toString();
    } catch (Exception e) {
      throw new IllegalStateException("Can\'t transform current GamificationSettings to string", e);
    }
  }

  @java.lang.SuppressWarnings("all")
  public GamificationSettings() {
  }

  @java.lang.SuppressWarnings("all")
  public long getThreshold() {
    return this.threshold;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractAddress() {
    return this.contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriodType getPeriodType() {
    return this.periodType;
  }

  @java.lang.SuppressWarnings("all")
  public GamificationRewardType getRewardType() {
    return this.rewardType;
  }

  @java.lang.SuppressWarnings("all")
  public double getTotalBudget() {
    return this.totalBudget;
  }

  @java.lang.SuppressWarnings("all")
  public double getBudgetPerMember() {
    return this.budgetPerMember;
  }

  @java.lang.SuppressWarnings("all")
  public void setThreshold(final long threshold) {
    this.threshold = threshold;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAddress(final String contractAddress) {
    this.contractAddress = contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setPeriodType(final RewardPeriodType periodType) {
    this.periodType = periodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setRewardType(final GamificationRewardType rewardType) {
    this.rewardType = rewardType;
  }

  @java.lang.SuppressWarnings("all")
  public void setTotalBudget(final double totalBudget) {
    this.totalBudget = totalBudget;
  }

  @java.lang.SuppressWarnings("all")
  public void setBudgetPerMember(final double budgetPerMember) {
    this.budgetPerMember = budgetPerMember;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof GamificationSettings)) return false;
    final GamificationSettings other = (GamificationSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getThreshold() != other.getThreshold()) return false;
    final java.lang.Object this$contractAddress = this.getContractAddress();
    final java.lang.Object other$contractAddress = other.getContractAddress();
    if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) return false;
    final java.lang.Object this$periodType = this.getPeriodType();
    final java.lang.Object other$periodType = other.getPeriodType();
    if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) return false;
    final java.lang.Object this$rewardType = this.getRewardType();
    final java.lang.Object other$rewardType = other.getRewardType();
    if (this$rewardType == null ? other$rewardType != null : !this$rewardType.equals(other$rewardType)) return false;
    if (java.lang.Double.compare(this.getTotalBudget(), other.getTotalBudget()) != 0) return false;
    if (java.lang.Double.compare(this.getBudgetPerMember(), other.getBudgetPerMember()) != 0) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof GamificationSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final long $threshold = this.getThreshold();
    result = result * PRIME + (int) ($threshold >>> 32 ^ $threshold);
    final java.lang.Object $contractAddress = this.getContractAddress();
    result = result * PRIME + ($contractAddress == null ? 43 : $contractAddress.hashCode());
    final java.lang.Object $periodType = this.getPeriodType();
    result = result * PRIME + ($periodType == null ? 43 : $periodType.hashCode());
    final java.lang.Object $rewardType = this.getRewardType();
    result = result * PRIME + ($rewardType == null ? 43 : $rewardType.hashCode());
    final long $totalBudget = java.lang.Double.doubleToLongBits(this.getTotalBudget());
    result = result * PRIME + (int) ($totalBudget >>> 32 ^ $totalBudget);
    final long $budgetPerMember = java.lang.Double.doubleToLongBits(this.getBudgetPerMember());
    result = result * PRIME + (int) ($budgetPerMember >>> 32 ^ $budgetPerMember);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "GamificationSettings(threshold=" + this.getThreshold() + ", contractAddress=" + this.getContractAddress() + ", periodType=" + this.getPeriodType() + ", rewardType=" + this.getRewardType() + ", totalBudget=" + this.getTotalBudget() + ", budgetPerMember=" + this.getBudgetPerMember() + ")";
  }
}
