// Generated by delombok at Mon Jan 28 18:09:40 UTC 2019
package org.exoplatform.addon.ethereum.wallet.model;

import static org.exoplatform.addon.ethereum.wallet.service.utils.Utils.jsonArrayToList;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.*;

public class WalletPreferences implements Serializable {
  private static final String OVERVIEW_ACCOUNTS_PARAM = "overviewAccounts";
  private static final String PRINCIPAL_ACCOUNT_PARAM = "principalAccount";
  private static final String ENABLE_DELEGATION_PARAM = "enableDelegation";
  private static final String DATA_VERSION_PARAM = "dataVersion";
  private static final String PHRASE_PARAM = "phrase";
  private static final String WALLET_ADDRESS_PARAM = "walletAddress";
  private static final String DEFAULT_GAS_PARAM = "defaultGas";
  private static final String CURRENCY_PARAM = "currency";
  private static final long serialVersionUID = -5725443183560646198L;
  private Integer dataVersion = 0;
  private Long defaultGas = 0L;
  private String currency = "usd";
  private String walletAddress = null;
  private String phrase = null;
  private String principalAccount = null;
  private Set<String> overviewAccounts;
  private Boolean enableDelegation = null;

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put(CURRENCY_PARAM, currency);
      jsonObject.put(DEFAULT_GAS_PARAM, defaultGas);
      jsonObject.put(WALLET_ADDRESS_PARAM, walletAddress);
      jsonObject.put(PHRASE_PARAM, phrase);
      jsonObject.put(DATA_VERSION_PARAM, dataVersion);
      if (enableDelegation != null) {
        jsonObject.put(ENABLE_DELEGATION_PARAM, enableDelegation);
      }
      if (principalAccount != null) {
        jsonObject.put(PRINCIPAL_ACCOUNT_PARAM, principalAccount);
      }
      if (overviewAccounts != null) {
        jsonObject.put(OVERVIEW_ACCOUNTS_PARAM, new JSONArray(overviewAccounts));
      }
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  public static final WalletPreferences parseStringToObject(String jsonString) {
    if (StringUtils.isBlank(jsonString)) {
      return null;
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      WalletPreferences userPreferences = new WalletPreferences();
      if (jsonObject.has(CURRENCY_PARAM)) {
        userPreferences.setCurrency(jsonObject.getString(CURRENCY_PARAM));
      }
      if (jsonObject.has(DEFAULT_GAS_PARAM)) {
        userPreferences.setDefaultGas(jsonObject.getLong(DEFAULT_GAS_PARAM));
      }
      if (jsonObject.has(WALLET_ADDRESS_PARAM)) {
        userPreferences.setWalletAddress(jsonObject.getString(WALLET_ADDRESS_PARAM));
      }
      if (jsonObject.has(PHRASE_PARAM)) {
        userPreferences.setWalletAddress(jsonObject.getString(PHRASE_PARAM));
      }
      if (jsonObject.has(PRINCIPAL_ACCOUNT_PARAM)) {
        userPreferences.setPrincipalAccount(jsonObject.getString(PRINCIPAL_ACCOUNT_PARAM));
      }
      if (jsonObject.has(ENABLE_DELEGATION_PARAM)) {
        userPreferences.setEnableDelegation(jsonObject.getBoolean(ENABLE_DELEGATION_PARAM));
      }
      if (jsonObject.has(DATA_VERSION_PARAM)) {
        userPreferences.setDataVersion(jsonObject.getInt(DATA_VERSION_PARAM));
      }
      userPreferences.setOverviewAccounts(jsonArrayToList(jsonObject, OVERVIEW_ACCOUNTS_PARAM));
      return userPreferences;
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting JSON String to Object", e);
    }
  }

  @Override
  public String toString() {
    return toJSONString();
  }

  @java.lang.SuppressWarnings("all")
  public Integer getDataVersion() {
    return this.dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultGas() {
    return this.defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  public String getWalletAddress() {
    return this.walletAddress;
  }

  @java.lang.SuppressWarnings("all")
  public String getPhrase() {
    return this.phrase;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalAccount() {
    return this.principalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public Set<String> getOverviewAccounts() {
    return this.overviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getEnableDelegation() {
    return this.enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public void setDataVersion(final Integer dataVersion) {
    this.dataVersion = dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultGas(final Long defaultGas) {
    this.defaultGas = defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  public void setWalletAddress(final String walletAddress) {
    this.walletAddress = walletAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setPhrase(final String phrase) {
    this.phrase = phrase;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalAccount(final String principalAccount) {
    this.principalAccount = principalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public void setOverviewAccounts(final Set<String> overviewAccounts) {
    this.overviewAccounts = overviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public void setEnableDelegation(final Boolean enableDelegation) {
    this.enableDelegation = enableDelegation;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WalletPreferences)) return false;
    final WalletPreferences other = (WalletPreferences) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$dataVersion = this.getDataVersion();
    final java.lang.Object other$dataVersion = other.getDataVersion();
    if (this$dataVersion == null ? other$dataVersion != null : !this$dataVersion.equals(other$dataVersion)) return false;
    final java.lang.Object this$defaultGas = this.getDefaultGas();
    final java.lang.Object other$defaultGas = other.getDefaultGas();
    if (this$defaultGas == null ? other$defaultGas != null : !this$defaultGas.equals(other$defaultGas)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$walletAddress = this.getWalletAddress();
    final java.lang.Object other$walletAddress = other.getWalletAddress();
    if (this$walletAddress == null ? other$walletAddress != null : !this$walletAddress.equals(other$walletAddress)) return false;
    final java.lang.Object this$phrase = this.getPhrase();
    final java.lang.Object other$phrase = other.getPhrase();
    if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) return false;
    final java.lang.Object this$principalAccount = this.getPrincipalAccount();
    final java.lang.Object other$principalAccount = other.getPrincipalAccount();
    if (this$principalAccount == null ? other$principalAccount != null : !this$principalAccount.equals(other$principalAccount)) return false;
    final java.lang.Object this$overviewAccounts = this.getOverviewAccounts();
    final java.lang.Object other$overviewAccounts = other.getOverviewAccounts();
    if (this$overviewAccounts == null ? other$overviewAccounts != null : !this$overviewAccounts.equals(other$overviewAccounts)) return false;
    final java.lang.Object this$enableDelegation = this.getEnableDelegation();
    final java.lang.Object other$enableDelegation = other.getEnableDelegation();
    if (this$enableDelegation == null ? other$enableDelegation != null : !this$enableDelegation.equals(other$enableDelegation)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WalletPreferences;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $dataVersion = this.getDataVersion();
    result = result * PRIME + ($dataVersion == null ? 43 : $dataVersion.hashCode());
    final java.lang.Object $defaultGas = this.getDefaultGas();
    result = result * PRIME + ($defaultGas == null ? 43 : $defaultGas.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $walletAddress = this.getWalletAddress();
    result = result * PRIME + ($walletAddress == null ? 43 : $walletAddress.hashCode());
    final java.lang.Object $phrase = this.getPhrase();
    result = result * PRIME + ($phrase == null ? 43 : $phrase.hashCode());
    final java.lang.Object $principalAccount = this.getPrincipalAccount();
    result = result * PRIME + ($principalAccount == null ? 43 : $principalAccount.hashCode());
    final java.lang.Object $overviewAccounts = this.getOverviewAccounts();
    result = result * PRIME + ($overviewAccounts == null ? 43 : $overviewAccounts.hashCode());
    final java.lang.Object $enableDelegation = this.getEnableDelegation();
    result = result * PRIME + ($enableDelegation == null ? 43 : $enableDelegation.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public WalletPreferences() {
  }
}
