/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.ethereum.wallet.entity.TransactionEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class WalletTransactionDAO
extends GenericDAOJPAImpl<TransactionEntity, Long> {
    private static final String NETWORK_ID_PARAM = "networkId";

    public List<TransactionEntity> getContractTransactions(long networkId, String contractAddress) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getContractTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter("contractAddress", (Object)contractAddress.toLowerCase());
        return query.getResultList();
    }

    public List<TransactionEntity> getWalletTransactions(Long networkId, String address) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getWalletTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter("address", (Object)address.toLowerCase());
        return query.getResultList();
    }

    public List<TransactionEntity> getAllWalletTransactions(Long networkId, String address) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getAllWalletTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter("address", (Object)address.toLowerCase());
        return query.getResultList();
    }

    public List<TransactionEntity> getPendingTransactions() {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingTransactions", TransactionEntity.class);
        return query.getResultList();
    }

    public TransactionEntity getTransactionByHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getTransactionByHash", TransactionEntity.class);
        query.setParameter("hash", (Object)hash.toLowerCase());
        List resultList = query.getResultList();
        return resultList == null || resultList.isEmpty() ? null : (TransactionEntity)resultList.get(0);
    }
}

