/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.storage;

import java.io.Serializable;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.ethereum.wallet.dao.WalletTransactionDAO;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.storage.CachedTransactionStorage$AjcClosure1;
import org.exoplatform.addon.ethereum.wallet.storage.TransactionStorage;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.picocontainer.Startable;

public class CachedTransactionStorage
extends TransactionStorage
implements Startable {
    private CacheService cacheService;
    private ExoCache<String, TransactionDetail> transactionCache = null;
    private FutureExoCache<String, TransactionDetail, Object> transactionFutureCache = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CachedTransactionStorage(WalletTransactionDAO walletTransactionDAO) {
        super(walletTransactionDAO);
    }

    @ExoTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new CachedTransactionStorage$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public TransactionDetail getTransactionByHash(String hash, boolean onlyPending) {
        if (onlyPending) {
            return (TransactionDetail)this.transactionCache.get((Serializable)((Object)hash));
        }
        return (TransactionDetail)this.transactionFutureCache.get(null, (Object)hash);
    }

    @Override
    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        super.saveTransactionDetail(transactionDetail);
        if (transactionDetail.isPending()) {
            this.transactionCache.put((Serializable)((Object)transactionDetail.getHash()), (Object)transactionDetail);
        } else {
            this.transactionFutureCache.remove((Serializable)((Object)transactionDetail.getHash()));
        }
    }

    public void stop() {
    }

    private CacheService getCacheService() {
        if (this.cacheService == null) {
            this.cacheService = (CacheService)CommonsUtils.getService(CacheService.class);
        }
        return this.cacheService;
    }

    static {
        CachedTransactionStorage.ajc$preClinit();
    }

    static /* synthetic */ void start_aroundBody0(CachedTransactionStorage ajc$this, JoinPoint joinPoint) {
        ajc$this.transactionCache = ajc$this.getCacheService().getCacheInstance("wallet.transaction");
        Loader<String, TransactionDetail, Object> transactionLoader = new Loader<String, TransactionDetail, Object>(){

            public TransactionDetail retrieve(Object context, String hash) throws Exception {
                return CachedTransactionStorage.super.getTransactionByHash(hash, false);
            }
        };
        ajc$this.transactionFutureCache = new FutureExoCache((Loader)transactionLoader, ajc$this.transactionCache);
        List<TransactionDetail> pendingTransactions = ajc$this.getPendingTransactions();
        pendingTransactions.forEach(pendingTransaction -> this.transactionCache.put((Serializable)((Object)pendingTransaction.getHash()), pendingTransaction));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CachedTransactionStorage.java", CachedTransactionStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.addon.ethereum.wallet.storage.CachedTransactionStorage", "", "", "", "void"), 31);
    }
}

