/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.storage;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.dao.WalletTransactionDAO;
import org.exoplatform.addon.ethereum.wallet.entity.TransactionEntity;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;

public class TransactionStorage {
    private static final long MINIMUM_CREATED_DATE_MILLIS = ZonedDateTime.of(2018, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault().normalized()).toEpochSecond() * 1000L;
    private WalletTransactionDAO walletTransactionDAO;

    public TransactionStorage(WalletTransactionDAO walletTransactionDAO) {
        this.walletTransactionDAO = walletTransactionDAO;
    }

    public List<TransactionDetail> getPendingTransactions(long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingTransactions(networkId);
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public List<TransactionDetail> getContractTransactions(long networkId, String contractAddress, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getContractTransactions(networkId, StringUtils.lowerCase((String)contractAddress), limit);
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String hash, int limit, boolean pending, boolean administration) {
        boolean limitNotReached;
        List<TransactionEntity> transactions = this.walletTransactionDAO.getWalletTransactions(networkId, address = StringUtils.lowerCase((String)address), contractAddress, limit, pending, administration);
        boolean bl = limitNotReached = transactions != null && transactions.size() == limit;
        if (StringUtils.isNotBlank((CharSequence)hash) && limitNotReached && transactions.stream().noneMatch(transaction -> StringUtils.equalsIgnoreCase((CharSequence)transaction.getHash(), (CharSequence)hash))) {
            return this.getWalletTransactions(networkId, address, contractAddress, hash, limit * 2, pending, administration);
        }
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        TransactionEntity transactionEntity = this.toEntity(transactionDetail);
        if (transactionEntity.getId() == 0L) {
            transactionEntity = (TransactionEntity)this.walletTransactionDAO.create(transactionEntity);
            transactionDetail.setId(transactionEntity.getId());
        } else {
            this.walletTransactionDAO.update(transactionEntity);
        }
    }

    public TransactionDetail getAddressLastPendingTransactionSent(long networkId, String address) {
        TransactionEntity transactionEntity = this.walletTransactionDAO.getAddressLastPendingTransactionSent(networkId, address);
        return this.fromEntity(transactionEntity);
    }

    public TransactionDetail getTransactionByHash(String hash) {
        hash = Utils.formatTransactionHash((String)hash);
        TransactionEntity transactionEntity = this.walletTransactionDAO.getTransactionByHash(hash);
        return this.fromEntity(transactionEntity);
    }

    private TransactionDetail fromEntity(TransactionEntity entity) {
        if (entity == null) {
            return null;
        }
        TransactionDetail detail = new TransactionDetail();
        detail.setId(entity.getId());
        detail.setAdminOperation(entity.isAdminOperation());
        detail.setContractAddress(entity.getContractAddress());
        detail.setContractAmount(entity.getContractAmount());
        detail.setContractMethodName(entity.getContractMethodName());
        detail.setTimestamp(entity.getCreatedDate());
        if (entity.getCreatedDate() > 0L && entity.getCreatedDate() < MINIMUM_CREATED_DATE_MILLIS) {
            detail.setTimestamp(entity.getCreatedDate() * 1000L);
        }
        detail.setHash(entity.getHash());
        detail.setFrom(entity.getFromAddress());
        detail.setTo(entity.getToAddress());
        detail.setBy(entity.getByAddress());
        detail.setLabel(entity.getLabel());
        detail.setMessage(entity.getMessage());
        detail.setNetworkId(entity.getNetworkId());
        detail.setPending(entity.isPending());
        detail.setSucceeded(entity.isSuccess());
        detail.setValue(entity.getValue());
        return detail;
    }

    private TransactionEntity toEntity(TransactionDetail transactionDetail) {
        TransactionEntity transactionEntity = new TransactionEntity();
        if (transactionDetail.getId() > 0L) {
            transactionEntity.setId(transactionDetail.getId());
        }
        transactionEntity.setNetworkId(transactionDetail.getNetworkId());
        transactionEntity.setHash(Utils.formatTransactionHash((String)transactionDetail.getHash()));
        transactionEntity.setFromAddress(StringUtils.lowerCase((String)transactionDetail.getFrom()));
        transactionEntity.setToAddress(StringUtils.lowerCase((String)transactionDetail.getTo()));
        transactionEntity.setByAddress(StringUtils.lowerCase((String)transactionDetail.getBy()));
        transactionEntity.setContractAddress(StringUtils.lowerCase((String)transactionDetail.getContractAddress()));
        transactionEntity.setContractAmount(transactionDetail.getContractAmount());
        transactionEntity.setContractMethodName(transactionDetail.getContractMethodName());
        transactionEntity.setAdminOperation(transactionDetail.isAdminOperation());
        transactionEntity.setLabel(transactionDetail.getLabel());
        transactionEntity.setMessage(transactionDetail.getMessage());
        transactionEntity.setPending(transactionDetail.isPending());
        transactionEntity.setSuccess(transactionDetail.isSucceeded());
        transactionEntity.setValue(transactionDetail.getValue());
        transactionEntity.setCreatedDate(transactionDetail.getTimestamp());
        return transactionEntity;
    }
}

