// Generated by delombok at Fri Sep 20 09:50:51 UTC 2019
/*
   * Copyright (C) 2003-2019 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.addon.wallet.model.reward;

import static org.exoplatform.addon.wallet.utils.RewardUtils.*;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RewardReport {
  private RewardPeriod period = null;
  private Set<WalletReward> rewards = new HashSet<>();

  public long getPendingTransactionCount() {
    return rewards.stream().filter(rewardItem -> StringUtils.equals(rewardItem.getStatus(), TRANSACTION_STATUS_PENDING)).count();
  }

  public long getSuccessTransactionCount() {
    return rewards.stream().filter(rewardItem -> StringUtils.equals(rewardItem.getStatus(), TRANSACTION_STATUS_SUCCESS)).count();
  }

  public long getFailedTransactionCount() {
    return rewards.stream().filter(rewardItem -> StringUtils.equals(rewardItem.getStatus(), TRANSACTION_STATUS_FAILED)).count();
  }

  public long getTransactionsCount() {
    return rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null).count();
  }

  public Set<WalletReward> getValidRewards() {
    return rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0).collect(Collectors.toSet());
  }

  public double getRemainingTokensToSend() {
    return rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensSent() == 0 ? rewardItem.getTokensToSend() : 0).sum();
  }

  public long getValidRewardCount() {
    return rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0).count();
  }

  public double getTokensToSend() {
    return rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensToSend()).sum();
  }

  public double getTokensSent() {
    return rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensSent()).sum();
  }

  public boolean hasSuccessTransactions() {
    return getSuccessTransactionCount() > 0;
  }

  public boolean hasPendingTransactions() {
    return getPendingTransactionCount() > 0;
  }

  public boolean hasErrorTransactions() {
    return getFailedTransactionCount() > 0;
  }

  public boolean isCompletelyProceeded() {
    // Can be greater if in the mean time of transaction confirmation, a member
    // has been invalidated / disabled / deleted
    return getTransactionsCount() > 0 && getSuccessTransactionCount() >= getValidRewardCount();
  }

  @java.lang.SuppressWarnings("all")
  public RewardReport() {
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriod getPeriod() {
    return this.period;
  }

  @java.lang.SuppressWarnings("all")
  public Set<WalletReward> getRewards() {
    return this.rewards;
  }

  @java.lang.SuppressWarnings("all")
  public void setPeriod(final RewardPeriod period) {
    this.period = period;
  }

  @java.lang.SuppressWarnings("all")
  public void setRewards(final Set<WalletReward> rewards) {
    this.rewards = rewards;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RewardReport)) return false;
    final RewardReport other = (RewardReport) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$period = this.getPeriod();
    final java.lang.Object other$period = other.getPeriod();
    if (this$period == null ? other$period != null : !this$period.equals(other$period)) return false;
    final java.lang.Object this$rewards = this.getRewards();
    final java.lang.Object other$rewards = other.getRewards();
    if (this$rewards == null ? other$rewards != null : !this$rewards.equals(other$rewards)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RewardReport;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $period = this.getPeriod();
    result = result * PRIME + ($period == null ? 43 : $period.hashCode());
    final java.lang.Object $rewards = this.getRewards();
    result = result * PRIME + ($rewards == null ? 43 : $rewards.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "RewardReport(period=" + this.getPeriod() + ", rewards=" + this.getRewards() + ")";
  }
}
