// Generated by delombok at Wed Dec 30 11:33:42 UTC 2020
package org.exoplatform.wallet.model.reward;

import static org.exoplatform.wallet.utils.RewardUtils.*;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import lombok.*;
import lombok.EqualsAndHashCode.Exclude;

public class WalletReward implements Serializable {
  private static final long serialVersionUID = -4328398843364453949L;
  private Wallet wallet;
  private List<RewardTeam> teams;
  private TransactionDetail transaction;
  private Set<WalletPluginReward> rewards;
  private RewardPeriod period;

  public long getIdentityId() {
    return wallet == null ? 0 : wallet.getTechnicalId();
  }

  public boolean isEnabled() {
    if (wallet == null) {
      throw new IllegalStateException("wallet isn\'t loaded");
    }
    if (StringUtils.isNotBlank(wallet.getAddress()) && wallet.getIsApproved() == null) {
      throw new IllegalStateException("wallet blockchain state isn\'t loaded");
    }
    return wallet.isEnabled() && !wallet.isDeletedUser() && !wallet.isDisabledUser() && StringUtils.isNotBlank(wallet.getAddress()) && wallet.getIsApproved();
  }

  public String getPoolName() {
    if (teams == null) {
      return null;
    }
    Set<String> teamNames = teams.stream().map(RewardTeam::getName).collect(Collectors.toSet());
    return StringUtils.join(teamNames, ",");
  }

  public RewardTeam getTeam() {
    if (teams == null || teams.isEmpty()) {
      return null;
    }
    return teams.get(0);
  }

  public String getStatus() {
    if (transaction == null) {
      return null;
    }
    if (transaction.isPending()) {
      return TRANSACTION_STATUS_PENDING;
    } else if (transaction.isSucceeded()) {
      return TRANSACTION_STATUS_SUCCESS;
    } else {
      return TRANSACTION_STATUS_FAILED;
    }
  }

  public double getTokensSent() {
    if (transaction == null) {
      return 0;
    } else {
      return transaction.getContractAmount();
    }
  }

  public double getTokensToSend() {
    if (rewards == null || rewards.isEmpty()) {
      return 0;
    } else {
      return rewards.stream().mapToDouble(reward -> reward.getAmount()).sum();
    }
  }

  public double getPoolTokensToSend() {
    if (rewards == null || rewards.isEmpty()) {
      return 0;
    } else {
      return rewards.stream().filter(WalletPluginReward::isPoolsUsed).mapToDouble(reward -> reward.getAmount()).sum();
    }
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getWallet() {
    return this.wallet;
  }

  @java.lang.SuppressWarnings("all")
  public List<RewardTeam> getTeams() {
    return this.teams;
  }

  @java.lang.SuppressWarnings("all")
  public TransactionDetail getTransaction() {
    return this.transaction;
  }

  @java.lang.SuppressWarnings("all")
  public Set<WalletPluginReward> getRewards() {
    return this.rewards;
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriod getPeriod() {
    return this.period;
  }

  @java.lang.SuppressWarnings("all")
  public void setWallet(final Wallet wallet) {
    this.wallet = wallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setTeams(final List<RewardTeam> teams) {
    this.teams = teams;
  }

  @java.lang.SuppressWarnings("all")
  public void setTransaction(final TransactionDetail transaction) {
    this.transaction = transaction;
  }

  @java.lang.SuppressWarnings("all")
  public void setRewards(final Set<WalletPluginReward> rewards) {
    this.rewards = rewards;
  }

  @java.lang.SuppressWarnings("all")
  public void setPeriod(final RewardPeriod period) {
    this.period = period;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WalletReward)) return false;
    final WalletReward other = (WalletReward) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$wallet = this.getWallet();
    final java.lang.Object other$wallet = other.getWallet();
    if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WalletReward;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $wallet = this.getWallet();
    result = result * PRIME + ($wallet == null ? 43 : $wallet.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "WalletReward(wallet=" + this.getWallet() + ", teams=" + this.getTeams() + ", transaction=" + this.getTransaction() + ", rewards=" + this.getRewards() + ", period=" + this.getPeriod() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public WalletReward(final Wallet wallet, final List<RewardTeam> teams, final TransactionDetail transaction, final Set<WalletPluginReward> rewards, final RewardPeriod period) {
    this.wallet = wallet;
    this.teams = teams;
    this.transaction = transaction;
    this.rewards = rewards;
    this.period = period;
  }

  @java.lang.SuppressWarnings("all")
  public WalletReward() {
  }
}
