/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.security.SignatureException;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;

public class SignedRawTransaction
extends RawTransaction {
    private static final int CHAIN_ID_INC = 35;
    private static final int LOWER_REAL_V = 27;
    private Sign.SignatureData signatureData;

    public SignedRawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, Sign.SignatureData signatureData) {
        super(nonce, gasPrice, gasLimit, to, value, data);
        this.signatureData = signatureData;
    }

    public Sign.SignatureData getSignatureData() {
        return this.signatureData;
    }

    public String getFrom() throws SignatureException {
        Integer chainId = this.getChainId();
        byte[] encodedTransaction = null == chainId ? TransactionEncoder.encode(this) : TransactionEncoder.encode((RawTransaction)this, chainId.byteValue());
        byte v = this.signatureData.getV();
        byte[] r = this.signatureData.getR();
        byte[] s = this.signatureData.getS();
        Sign.SignatureData signatureDataV = new Sign.SignatureData(this.getRealV(v), r, s);
        BigInteger key = Sign.signedMessageToKey(encodedTransaction, signatureDataV);
        return "0x" + Keys.getAddress(key);
    }

    public void verify(String from) throws SignatureException {
        String actualFrom = this.getFrom();
        if (!actualFrom.equals(from)) {
            throw new SignatureException("from mismatch");
        }
    }

    private byte getRealV(byte v) {
        if (v == 27 || v == 28) {
            return v;
        }
        int realV = 27;
        int inc = 0;
        if (v % 2 == 0) {
            inc = 1;
        }
        return (byte)(realV + inc);
    }

    public Integer getChainId() {
        byte v = this.signatureData.getV();
        if (v == 27 || v == 28) {
            return null;
        }
        Integer chainId = (v - 35) / 2;
        return chainId;
    }
}

