/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletAddressLabel;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.storage.AddressLabelStorage;
import org.exoplatform.addon.wallet.storage.WalletStorage;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.picocontainer.Startable;

public class WalletAccountServiceImpl
implements WalletAccountService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(WalletAccountServiceImpl.class);
    private static final String USER_MESSAGE_IN_EXCEPTION = "User '";
    private static final String USER_MESSAGE_PREFIX = "User ";
    private static final String CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS = "Can't find wallet associated to address ";
    private static final String ADDRESS_PARAMTER_IS_MANDATORY = "address paramter is mandatory";
    private WalletTokenAdminService tokenAdminService;
    private WalletStorage accountStorage;
    private AddressLabelStorage labelStorage;
    private ListenerService listenerService;
    private String adminAccountPassword;

    public WalletAccountServiceImpl(WalletStorage walletAccountStorage, AddressLabelStorage labelStorage, InitParams params) {
        this.accountStorage = walletAccountStorage;
        this.labelStorage = labelStorage;
        if (params != null && params.containsKey((Object)"admin.wallet.key") && StringUtils.isNotBlank((String)params.getValueParam("admin.wallet.key").getValue())) {
            this.adminAccountPassword = params.getValueParam("admin.wallet.key").getValue();
        }
    }

    public void start() {
        Provider provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
        if (provider == null) {
            LOG.info((Object)"No BouncyCastleProvider defined, register new one");
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        }
        LOG.info("Start wallet with BouncyCastleProvider version: {}", new Object[]{provider.getVersion()});
    }

    public void stop() {
    }

    public Set<Wallet> listWallets() {
        Set<Wallet> wallets = this.accountStorage.listWallets();
        wallets.forEach(wallet -> WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet));
        return wallets;
    }

    public long getWalletsCount() {
        return this.accountStorage.getWalletsCount();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        if (identityId == 0L) {
            throw new IllegalArgumentException("identityId is mandatory");
        }
        Identity identity = WalletUtils.getIdentityById((long)identityId);
        if (identity == null) {
            LOG.debug("Can't find identity with id {}", new Object[]{identityId});
            return null;
        }
        return this.getWalletOfIdentity(identity);
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId, String currentUser) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet != null) {
            if (WalletType.isSpace((String)wallet.getType())) {
                wallet.setSpaceAdministrator(WalletUtils.isUserSpaceManager((String)wallet.getId(), (String)currentUser));
                if (!wallet.isSpaceAdministrator()) {
                    WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
            } else if (!StringUtils.equals((String)wallet.getId(), (String)currentUser)) {
                WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
            }
        }
        return wallet;
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId) {
        Identity identity;
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        WalletType accountType = WalletType.getType((String)type);
        if (accountType.isSpace()) {
            remoteId = WalletUtils.getSpacePrettyName((String)remoteId);
        }
        if ((identity = WalletUtils.getIdentityByTypeAndId((WalletType)accountType, (String)remoteId)) == null) {
            LOG.debug("Can't find identity with id {} and type {}. It may be removed.", new Object[]{remoteId, accountType.getId()});
            return null;
        }
        return this.getWalletOfIdentity(identity);
    }

    public void savePrivateKeyByTypeAndId(String type, String remoteId, String content, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            throw new IllegalStateException("Can't find " + type + " with remote id " + remoteId + ". Wallet private key will not be created.");
        }
        this.checkIsWalletOwner(wallet, currentUser, "save private key of wallet");
        this.accountStorage.saveWalletPrivateKey(wallet.getTechnicalId(), content);
    }

    public String getPrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        if (WalletType.isAdmin((String)type)) {
            throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' is not allowed to access private key of admin '" + remoteId + "'");
        }
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return null;
        }
        this.checkIsWalletOwner(wallet, currentUser, "get private key of wallet");
        return this.accountStorage.getWalletPrivateKey(wallet.getTechnicalId());
    }

    public String getPrivateKeyByTypeAndId(String type, String remoteId) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return null;
        }
        return this.accountStorage.getWalletPrivateKey(wallet.getTechnicalId());
    }

    public void removePrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser, "remove private key of wallet");
        this.accountStorage.removeWalletPrivateKey(wallet.getTechnicalId());
    }

    public Wallet getWalletByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet != null) {
            Identity identity = WalletUtils.getIdentityById((long)wallet.getTechnicalId());
            WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        }
        return wallet;
    }

    public void createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        this.getTokenAdminService().createAdminAccount(privateKey, currentUser);
    }

    public void saveWallet(Wallet wallet) {
        this.accountStorage.saveWallet(wallet, false);
    }

    public Wallet saveWalletBackupState(String currentUser, long identityId, boolean backupState) throws IllegalAccessException {
        if (identityId == 0L) {
            throw new IllegalArgumentException("Wallet technical id is mandatory");
        }
        if (StringUtils.isBlank((String)currentUser)) {
            throw new IllegalArgumentException("User name is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet with id " + identityId);
        }
        this.checkIsWalletOwner(wallet, currentUser, "save wallet");
        return this.accountStorage.saveWalletBackupState(identityId, backupState);
    }

    public void saveWalletAddress(Wallet wallet, String currentUser, boolean broadcast) throws IllegalAccessException {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        if (StringUtils.isBlank((String)wallet.getAddress())) {
            throw new IllegalArgumentException("Wallet address is empty, thus it can't be saved");
        }
        WalletUtils.computeWalletIdentity((Wallet)wallet);
        Wallet oldWallet = this.accountStorage.getWalletByIdentityId(wallet.getTechnicalId());
        boolean isNew = oldWallet == null;
        this.checkCanSaveWallet(wallet, oldWallet, currentUser);
        if (isNew) {
            wallet.setInitializationState(WalletInitializationState.NEW.name());
        } else if (!StringUtils.equalsIgnoreCase((String)oldWallet.getAddress(), (String)wallet.getAddress())) {
            wallet.setInitializationState(WalletInitializationState.MODIFIED.name());
        } else {
            wallet.setInitializationState(oldWallet.getInitializationState());
        }
        wallet.setEnabled(isNew || oldWallet.isEnabled());
        this.setWalletPassPhrase(wallet, oldWallet);
        this.accountStorage.saveWallet(wallet, isNew);
        if (!isNew) {
            this.accountStorage.removeWalletPrivateKey(wallet.getTechnicalId());
        }
        if (broadcast) {
            String eventName = isNew ? "exo.addon.wallet.addressAssociation.new" : "exo.addon.wallet.addressAssociation.modification";
            wallet = wallet.clone();
            try {
                this.getListenerService().broadcast(eventName, (Object)(oldWallet == null ? null : oldWallet.clone()), (Object)wallet);
            }
            catch (Exception e) {
                LOG.error("Error broadcasting event {} for wallet {}", new Object[]{eventName, wallet, e});
            }
        }
    }

    public void removeWalletByAddress(String address, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void removeWalletByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("wallet type parameter is mandatory");
        }
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("remote id parameter is mandatory");
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet of " + type + " " + remoteId);
        }
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.getType((String)type), (String)remoteId);
        if (identity == null) {
            LOG.debug("Can't find identity with type/id: {}/{}", new Object[]{type, remoteId});
            return;
        }
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet with type/id: " + type + "/" + remoteId);
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void enableWalletByAddress(String address, boolean enable, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to disable wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        wallet.setEnabled(enable);
        this.accountStorage.saveWallet(wallet, false);
    }

    public void setInitializationStatus(String address, WalletInitializationState initializationState, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        if (initializationState == null) {
            throw new IllegalArgumentException("Initialization state is mandatory");
        }
        if (StringUtils.isBlank((String)currentUser)) {
            throw new IllegalArgumentException("Modifier username is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            WalletInitializationState oldInitializationState = WalletInitializationState.valueOf((String)wallet.getInitializationState());
            if (oldInitializationState != WalletInitializationState.DENIED || initializationState != WalletInitializationState.MODIFIED || !this.isWalletOwner(wallet, currentUser)) {
                throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to change wallet status with address " + address + " to " + initializationState.name());
            }
            if (oldInitializationState == WalletInitializationState.INITIALIZED) {
                throw new IllegalAccessException("Wallet was already marked as initialized, thus the status for address " + address + " can't change to status " + initializationState.name());
            }
        }
        wallet.setInitializationState(initializationState.name());
        this.accountStorage.saveWallet(wallet, false);
    }

    public void setInitializationStatus(String address, WalletInitializationState initializationState) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        if (initializationState == null) {
            throw new IllegalArgumentException("Initialization state is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            LOG.info((Object)(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address));
            return;
        }
        wallet.setInitializationState(initializationState.name());
        this.accountStorage.saveWallet(wallet, false);
    }

    public void checkCanSaveWallet(Wallet wallet, Wallet storedWallet, String currentUser) throws IllegalAccessException {
        if (WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser, "save wallet");
        if (storedWallet != null && !storedWallet.isEnabled()) {
            LOG.error("User '{}' attempts to modify his wallet while it's disabled", new Object[]{currentUser});
            throw new IllegalAccessException();
        }
        Wallet walletByAddress = this.accountStorage.getWalletByAddress(wallet.getAddress());
        if (walletByAddress != null && walletByAddress.getId() != null && !walletByAddress.getId().equals(wallet.getId())) {
            throw new IllegalStateException(USER_MESSAGE_PREFIX + currentUser + " attempts to assign address of wallet of " + walletByAddress);
        }
    }

    public boolean isWalletOwner(Wallet wallet, String currentUser) {
        if (wallet == null) {
            return false;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            try {
                return WalletUtils.checkUserIsSpaceManager((String)remoteId, (String)currentUser, (boolean)false);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return StringUtils.equals((String)currentUser, (String)remoteId);
    }

    public WalletAddressLabel saveOrDeleteAddressLabel(WalletAddressLabel label, String currentUser) {
        if (label == null) {
            throw new IllegalArgumentException("Label is empty");
        }
        long labelId = label.getId();
        if (labelId > 0L) {
            Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)currentUser);
            if (identity == null) {
                throw new IllegalStateException("Can't find identity of user " + currentUser);
            }
            WalletAddressLabel storedLabel = this.labelStorage.getLabel(labelId);
            if (storedLabel == null) {
                label.setId(0L);
            } else if (!StringUtils.equals((String)identity.getId(), (String)String.valueOf(storedLabel.getIdentityId()))) {
                LOG.info("{} user modified address {} label from '{}' to '{}'", new Object[]{currentUser, label.getAddress(), storedLabel.getLabel(), label.getLabel()});
            }
        }
        if (StringUtils.isBlank((String)label.getLabel())) {
            if (labelId > 0L) {
                this.labelStorage.removeLabel(label);
            }
        } else {
            label = this.labelStorage.saveLabel(label);
        }
        return label;
    }

    public Set<WalletAddressLabel> getAddressesLabelsVisibleBy(String currentUser) {
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            return Collections.emptySet();
        }
        return this.labelStorage.getAllLabels();
    }

    public String getAdminAccountPassword() {
        return this.adminAccountPassword;
    }

    private void checkIsWalletOwner(Wallet wallet, String currentUser, String operationMessage) throws IllegalAccessException {
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            WalletUtils.checkUserIsSpaceManager((String)remoteId, (String)currentUser, (boolean)true);
        } else if (type.isAdmin()) {
            if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
                throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' attempts to " + operationMessage + " of admin");
            }
        } else if (type.isUser() && !StringUtils.equals((String)currentUser, (String)remoteId)) {
            throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' attempts to " + operationMessage + " of user '" + remoteId + "'");
        }
    }

    private Wallet getWalletOfIdentity(Identity identity) {
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId);
        if (wallet == null) {
            wallet = new Wallet();
            wallet.setEnabled(true);
        }
        WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        return wallet;
    }

    private void setWalletPassPhrase(Wallet wallet, Wallet oldWallet) {
        if (StringUtils.isBlank((String)wallet.getPassPhrase())) {
            if (oldWallet == null || StringUtils.isBlank((String)oldWallet.getPassPhrase())) {
                wallet.setPassPhrase(this.generateSecurityPhrase());
            } else {
                wallet.setPassPhrase(oldWallet.getPassPhrase());
            }
        }
    }

    private String generateSecurityPhrase() {
        return RandomStringUtils.random((int)20, (char[])WalletUtils.SIMPLE_CHARS);
    }

    private WalletTokenAdminService getTokenAdminService() {
        if (this.tokenAdminService == null) {
            this.tokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.tokenAdminService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

