/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.model.transaction.TransactionStatistics;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/transaction")
@RolesAllowed(value={"users"})
@Api(value="/wallet/api/transaction", description="Manages internally stored transactions")
public class WalletTransactionREST
implements ResourceContainer {
    private static final String EMPTY_ADDRESS_ERROR = "Bad request sent to server with empty address {}";
    private static final Log LOG = ExoLogger.getLogger(WalletTransactionREST.class);
    private WalletTransactionService transactionService;

    public WalletTransactionREST(WalletTransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @POST
    @Path(value="saveTransactionDetails")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Save transaction details in internal datasource", httpMethod="POST", response=Response.class, consumes="application/json", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveTransactionDetails(@ApiParam(value="transaction detail object", required=true) TransactionDetail transactionDetail) {
        if (transactionDetail == null || StringUtils.isBlank((String)transactionDetail.getHash()) || StringUtils.isBlank((String)transactionDetail.getFrom())) {
            LOG.warn("Bad request sent to server with empty transaction details: {}", new Object[]{transactionDetail == null ? "" : transactionDetail.toString()});
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        try {
            this.transactionService.saveTransactionDetail(transactionDetail, currentUserId, false);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is attempting to save transaction {}", new Object[]{currentUserId, transactionDetail, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving transaction message", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getSavedTransactionByHash")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get saved transaction in internal database by hash", httpMethod="GET", response=Response.class, produces="application/json", notes="returns transaction detail")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSavedTransactionByHash(@ApiParam(value="transaction hash", required=true) @QueryParam(value="hash") String hash) {
        if (StringUtils.isBlank((String)hash)) {
            LOG.warn("Empty transaction hash", new Object[]{hash});
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = this.transactionService.getTransactionByHash(hash, WalletUtils.getCurrentUserId());
            return Response.ok((Object)transactionDetail).build();
        }
        catch (Exception e) {
            LOG.error("Error getting transaction with hash {}", new Object[]{hash, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactionsAmounts")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get token amounts sent per each period of time by a wallet identified by its address", httpMethod="GET", response=Response.class, produces="application/json", notes="returns transaction statistics object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTransactionsAmounts(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="periodicity : month or year", required=true) @QueryParam(value="periodicity") String periodicity, @ApiParam(value="user locale language", required=false) @QueryParam(value="lang") String lang) {
        if (StringUtils.isBlank((String)periodicity)) {
            LOG.warn((Object)"Bad request sent to server with empty periodicity parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        try {
            TransactionStatistics transactionStatistics = this.transactionService.getTransactionStatistics(address, periodicity, new Locale(lang));
            return Response.ok((Object)transactionStatistics).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions statistics of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactions")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get list of transactions of an address", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of transaction detail object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTransactions(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="token contract address to filter with", required=false) @QueryParam(value="contractAddress") String contractAddress, @ApiParam(value="token contract method to filter with", required=false) @QueryParam(value="contractMethodName") String contractMethodName, @ApiParam(value="transaction hash to include in response", required=false) @QueryParam(value="hash") String hash, @ApiParam(value="limit transactions to retrieve", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="whether to include only pending or not", required=false) @QueryParam(value="pending") boolean onlyPending, @ApiParam(value="whether to include administration transactions or not", required=false) @QueryParam(value="administration") boolean administration) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        try {
            List<TransactionDetail> transactionDetails = this.transactionService.getTransactions(address, contractAddress, contractMethodName, hash, limit, onlyPending, administration, currentUserId);
            return Response.ok(transactionDetails).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display transactions of address {}", new Object[]{currentUserId, address});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }
}

