/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.FundsRequest;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.JsonGenerator;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class WalletUtils {
    private static final Log LOG = ExoLogger.getLogger(WalletUtils.class);
    public static final char[] SIMPLE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final String COMETD_CHANNEL = "/eXo/Application/Addons/Wallet";
    public static final int ETHER_TO_WEI_DECIMALS = 18;
    public static final JsonParser JSON_PARSER = new JsonParserImpl();
    public static final JsonGenerator JSON_GENERATOR = new JsonGeneratorImpl();
    public static final String EMPTY_HASH = "0x0000000000000000000000000000000000000000000000000000000000000000";
    public static final String NETWORK_ID = "networkId";
    public static final String NETWORK_URL = "networkURL";
    public static final String NETWORK_WS_URL = "networkWSURL";
    public static final String ACCESS_PERMISSION = "accessPermission";
    public static final String TOKEN_ADDRESS = "tokenAddress";
    public static final String GAS_LIMIT = "gasLimit";
    public static final String MIN_GAS_PRICE = "cheapGasPrice";
    public static final String NORMAL_GAS_PRICE = "normalGasPrice";
    public static final String MAX_GAS_PRICE = "fastGasPrice";
    public static final String LAST_BLOCK_NUMBER_KEY_NAME = "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER";
    public static final String SCOPE_NAME = "ADDONS_ETHEREUM_WALLET";
    public static final String INITIAL_FUNDS_KEY_NAME = "INITIAL_FUNDS";
    public static final String SETTINGS_KEY_NAME = "ADDONS_ETHEREUM_WALLET_SETTINGS";
    public static final Context WALLET_CONTEXT = Context.GLOBAL;
    public static final Scope WALLET_SCOPE = Scope.APPLICATION.id("ADDONS_ETHEREUM_WALLET");
    public static final String WALLET_USER_TRANSACTION_NAME = "WALLET_USER_TRANSACTION";
    public static final String WALLET_BROWSER_PHRASE_NAME = "WALLET_BROWSER_PHRASE";
    public static final String ADMIN_KEY_PARAMETER = "admin.wallet.key";
    public static final String ABI_PATH_PARAMETER = "contract.abi.path";
    public static final String BIN_PATH_PARAMETER = "contract.bin.path";
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String REWARDINGS_GROUP = "/platform/rewarding";
    public static final String WALLET_ADMIN_REMOTE_ID = "admin";
    public static final String PRINCIPAL_CONTRACT_ADMIN_NAME = "Admin";
    public static final String WALLET_MODIFIED_EVENT = "exo.addon.wallet.modified";
    public static final String CONTRACT_MODIFIED_EVENT = "exo.addon.wallet.contract.modified";
    public static final String TRANSACTION_MODIFIED_EVENT = "exo.addon.wallet.transaction.modified";
    public static final String WALLET_ENABLED_EVENT = "exo.addon.wallet.enabled";
    public static final String WALLET_DISABLED_EVENT = "exo.addon.wallet.disabled";
    public static final String WALLET_INITIALIZATION_MODIFICATION_EVENT = "exo.addon.wallet.initialization.state";
    public static final String CONTRACT_FUNC_TRANSFER = "transfer";
    public static final String CONTRACT_FUNC_TRANSFERFROM = "transferFrom";
    public static final String CONTRACT_FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String CONTRACT_FUNC_TRANSFORMTOVESTED = "transformToVested";
    public static final String CONTRACT_FUNC_APPROVE = "approve";
    public static final String CONTRACT_FUNC_INITIALIZEACCOUNT = "initializeAccount";
    public static final String CONTRACT_FUNC_REWARD = "reward";
    public static final String CONTRACT_FUNC_ADDADMIN = "addAdmin";
    public static final String NEW_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.new";
    public static final String MODIFY_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.modification";
    public static final String KNOWN_TRANSACTION_MINED_EVENT = "exo.addon.wallet.transaction.mined";
    public static final String TRANSACTION_PENDING_MAX_DAYS = "transaction.pending.maxDays";
    public static final String WALLET_SENDER_NOTIFICATION_ID = "EtherSenderNotificationPlugin";
    public static final String WALLET_RECEIVER_NOTIFICATION_ID = "EtherReceiverNotificationPlugin";
    public static final String FUNDS_REQUEST_NOTIFICATION_ID = "FundsRequestNotificationPlugin";
    public static final String FUNDS_REQUEST_SENT = "sent";
    public static final String CONTRACT_ADDRESS = "contractAddress";
    public static final String AMOUNT = "amount";
    public static final String SYMBOL = "symbol";
    public static final String MESSAGE = "message";
    public static final String HASH = "hash";
    public static final String ACCOUNT_TYPE = "account_type";
    public static final String RECEIVER_TYPE = "receiver_type";
    public static final String AVATAR = "avatar";
    public static final String SENDER = "sender";
    public static final String USER = "userFullname";
    public static final String USER_URL = "userUrl";
    public static final String SENDER_URL = "senderUrl";
    public static final String RECEIVER = "receiver";
    public static final String RECEIVER_URL = "receiverUrl";
    public static final String FUNDS_ACCEPT_URL = "fundsAcceptUrl";
    public static final String OPERATION_GET_TRANSACTION_COUNT = "eth_getTransactionCount";
    public static final String OPERATION_READ_FROM_TOKEN = "eth_call";
    public static final String OPERATION_GET_ETHER_BALANCE = "eth_getBalance";
    public static final String OPERATION_GET_LAST_BLOCK_NUMBER = "eth_blockNumber";
    public static final String OPERATION_GET_TRANSACTION = "eth_getTransactionByHash";
    public static final String OPERATION_GET_TRANSACTION_RECEIPT = "eth_getTransactionReceipt";
    public static final String OPERATION_FILTER_CONTRACT_TRANSACTIONS = "eth_getLogs";
    public static final String OPERATION_SEND_TRANSACTION = "eth_sendRawTransaction";
    public static final String OPERATION_SEND_ADMIN_TOKEN_TRANSACTION = "SEND_TOKEN_ADMIN_TRANSACTION";
    public static final String OPERATION_SEND_ADMIN_ETHER_TRANSACTION = "SEND_ADMIN_ETHER_TRANSACTION";
    public static final ArgumentLiteral<Wallet> FUNDS_REQUEST_SENDER_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "senderFullName");
    public static final ArgumentLiteral<Wallet> SENDER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "senderAccountDetail");
    public static final ArgumentLiteral<Wallet> RECEIVER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "receiverAccountDetail");
    public static final ArgumentLiteral<FundsRequest> FUNDS_REQUEST_PARAMETER = new ArgumentLiteral(FundsRequest.class, "fundsRequest");
    public static final ArgumentLiteral<ContractDetail> CONTRACT_DETAILS_PARAMETER = new ArgumentLiteral(ContractDetail.class, "contractDetails");
    public static final ArgumentLiteral<Double> AMOUNT_PARAMETER = new ArgumentLiteral(Double.class, "amount");
    public static final ArgumentLiteral<String> MESSAGE_PARAMETER = new ArgumentLiteral(String.class, "message");
    public static final ArgumentLiteral<String> HASH_PARAMETER = new ArgumentLiteral(String.class, "hash");
    public static final ArgumentLiteral<String> SYMBOL_PARAMETER = new ArgumentLiteral(String.class, "symbol");
    public static final ArgumentLiteral<String> CONTRACT_ADDRESS_PARAMETER = new ArgumentLiteral(String.class, "contractAddress");
    public static final String RESOURCE_BUNDLE_NAME = "locale.addon.Wallet";
    public static final String TOKEN_FUNC_SETSELLPRICE = "setSellPrice";
    public static final String TOKEN_FUNC_INITIALIZEACCOUNT = "initializeAccount";
    public static final String TOKEN_FUNC_DEPOSIT_FUNDS = "depositFunds";
    public static final String ETHER_FUNC_SEND_FUNDS = "ether_transfer";

    private WalletUtils() {
    }

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static List<String> getNotificationReceiversUsers(Wallet wallet, String excludedId) {
        if (WalletType.isSpace(wallet.getType())) {
            Space space = WalletUtils.getSpace(wallet.getId());
            if (space == null) {
                return Collections.singletonList(wallet.getId());
            }
            String[] managers = space.getManagers();
            if (managers == null || managers.length == 0) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)excludedId)) {
                return Arrays.asList(managers);
            }
            return Arrays.stream(managers).filter(member -> !excludedId.equals(member)).collect(Collectors.toList());
        }
        if (WalletType.isUser(wallet.getType())) {
            return Collections.singletonList(wallet.getId());
        }
        return Collections.emptyList();
    }

    public static String getPermanentLink(Wallet wallet) {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        String remoteId = wallet.getId();
        String walletType = wallet.getType();
        try {
            if (StringUtils.isBlank((CharSequence)remoteId) || StringUtils.isBlank((CharSequence)walletType) || !WalletType.isUser(walletType) && !WalletType.isSpace(walletType)) {
                return wallet.getName();
            }
            if (WalletType.isUser(walletType)) {
                return LinkProvider.getProfileLink((String)remoteId);
            }
            if (WalletType.isSpace(walletType)) {
                Space space = WalletUtils.getSpace(remoteId);
                if (space == null) {
                    throw new IllegalStateException("Can't find space with id " + remoteId);
                }
                return WalletUtils.getPermanentLink(space);
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting profile link of {} {}", new Object[]{walletType, remoteId, e});
        }
        return StringUtils.isBlank((CharSequence)wallet.getName()) ? wallet.getAddress() : wallet.getName();
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(long identityId) {
        return WalletUtils.getIdentityById(String.valueOf(identityId));
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(String identityId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getIdentity(identityId, true);
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityByTypeAndId(WalletType type, String remoteId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(type.getProviderId(), remoteId, true);
    }

    public static String getSpacePrettyName(String id) {
        Space space = WalletUtils.getSpace(id);
        return space == null ? id : space.getPrettyName();
    }

    public static Space getSpace(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (id.indexOf("/spaces/") >= 0) {
            return spaceService.getSpaceByGroupId(id);
        }
        Space space = spaceService.getSpaceByPrettyName(id);
        if (space == null && (space = spaceService.getSpaceByGroupId("/spaces/" + id)) == null && (space = spaceService.getSpaceByDisplayName(id)) == null && (space = spaceService.getSpaceByUrl(id)) == null) {
            space = spaceService.getSpaceById(id);
        }
        return space;
    }

    public static void computeWalletIdentity(Wallet wallet) {
        if (wallet.getTechnicalId() == 0L) {
            org.exoplatform.social.core.identity.model.Identity identity;
            String remoteId = wallet.getId();
            if (StringUtils.isBlank((CharSequence)remoteId)) {
                throw new IllegalStateException("Wallet identityId and remoteId are empty, thus it can't be saved");
            }
            WalletType type = WalletType.getType(wallet.getType());
            if (type.isSpace()) {
                remoteId = WalletUtils.getSpacePrettyName(remoteId);
                wallet.setId(remoteId);
            }
            if ((identity = WalletUtils.getIdentityByTypeAndId(type, remoteId)) == null) {
                wallet.setEnabled(false);
                wallet.setDeletedUser(true);
            } else {
                wallet.setType(type.getId());
                wallet.setId(identity.getRemoteId());
                wallet.setTechnicalId(Long.parseLong(identity.getId()));
            }
        } else {
            org.exoplatform.social.core.identity.model.Identity identity = WalletUtils.getIdentityById(wallet.getTechnicalId());
            if (identity == null) {
                wallet.setEnabled(false);
                wallet.setDeletedUser(true);
            } else {
                WalletType type = WalletType.getType(identity.getProviderId());
                wallet.setType(type.getId());
                wallet.setId(identity.getRemoteId());
            }
        }
    }

    public static final boolean isUserRewardingAdmin(String username) {
        return WalletUtils.isUserMemberOfGroupOrUser(username, REWARDINGS_GROUP);
    }

    public static final boolean isUserMemberOfSpaceOrGroupOrUser(String username, String accessPermission) {
        boolean isMember = true;
        if (StringUtils.isNotBlank((CharSequence)accessPermission)) {
            Space space = WalletUtils.getSpace(accessPermission);
            isMember = space != null && WalletUtils.getSpaceService().isMember(space, username) || WalletUtils.isUserMemberOfGroupOrUser(username, accessPermission);
        }
        return isMember;
    }

    public static final boolean isUserMemberOfGroupOrUser(String username, String permissionExpression) {
        if (StringUtils.isBlank((CharSequence)permissionExpression)) {
            throw new IllegalArgumentException("Permission expression is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        Identity identity = ((IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class)).getIdentity(username);
        if (identity == null) {
            try {
                identity = ((Authenticator)CommonsUtils.getService(Authenticator.class)).createIdentity(username);
            }
            catch (Exception e) {
                LOG.warn("Error getting memberships of user {}", new Object[]{username, e});
            }
        }
        if (identity == null) {
            return false;
        }
        MembershipEntry membership = null;
        if (permissionExpression.contains(":")) {
            String[] permissionExpressionParts = permissionExpression.split(":");
            membership = new MembershipEntry(permissionExpressionParts[1], permissionExpressionParts[0]);
        } else if (permissionExpression.contains("/")) {
            membership = new MembershipEntry(permissionExpression, "*");
        } else {
            return StringUtils.equals((CharSequence)username, (CharSequence)permissionExpression);
        }
        return identity.isMemberOf(membership);
    }

    public static String getWalletLink(String receiverType, String receiverId) {
        if (receiverType == null || receiverId == null || WalletType.isUser(receiverType)) {
            return CommonsUtils.getCurrentDomain() + WalletUtils.getMyWalletLink();
        }
        Space space = WalletUtils.getSpace(receiverId);
        if (space == null) {
            return CommonsUtils.getCurrentDomain() + WalletUtils.getMyWalletLink();
        }
        String groupId = space.getGroupId().split("/")[2];
        return CommonsUtils.getCurrentDomain() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)groupId) + "/SpaceWallet";
    }

    public static String getMyWalletLink() {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        return "/" + PortalContainer.getInstance().getName() + "/" + userPortalConfigService.getDefaultPortal() + "/wallet";
    }

    public static String getPermanentLink(Space space) {
        if (space == null) {
            return null;
        }
        String groupId = space.getGroupId().split("/")[2];
        String spaceUrl = LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)groupId);
        if (StringUtils.isBlank((CharSequence)spaceUrl)) {
            return CommonsUtils.getCurrentDomain();
        }
        spaceUrl = CommonsUtils.getCurrentDomain() + spaceUrl;
        return "<a href=\"" + spaceUrl + "\" target=\"_blank\">" + StringEscapeUtils.escapeHtml((String)space.getDisplayName()) + "</a>";
    }

    public static String encodeString(String content) {
        try {
            return StringUtils.isBlank((CharSequence)content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error encoding content", e);
        }
    }

    public static String decodeString(String content) {
        try {
            return StringUtils.isBlank((CharSequence)content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error decoding content", e);
        }
    }

    public static boolean isUserSpaceManager(String id, String modifier) {
        try {
            return WalletUtils.checkUserIsSpaceManager(id, modifier, false);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static boolean canAccessWallet(Wallet wallet, String currentUser) {
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            return false;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType(wallet.getType());
        boolean isUserAdmin = WalletUtils.isUserRewardingAdmin(currentUser);
        if (isUserAdmin) {
            return true;
        }
        return type.isUser() && StringUtils.equals((CharSequence)currentUser, (CharSequence)remoteId) || type.isSpace() && WalletUtils.isUserSpaceMember(wallet.getId(), currentUser);
    }

    public static boolean isUserSpaceMember(String spaceId, String accesssor) {
        Space space = WalletUtils.getSpace(spaceId);
        if (space == null) {
            throw new IllegalStateException("Space not found with id '" + spaceId + "'");
        }
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return spaceService.isSuperManager(accesssor) || spaceService.isMember(space, accesssor) || spaceService.isManager(space, accesssor);
    }

    public static boolean checkUserIsSpaceManager(String spaceId, String modifier, boolean throwException) throws IllegalAccessException {
        Space space = WalletUtils.getSpace(spaceId);
        if (space == null) {
            throw new IllegalStateException("Space not found with id '" + spaceId + "'");
        }
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (!spaceService.isManager(space, modifier) && !spaceService.isSuperManager(modifier)) {
            if (throwException) {
                LOG.error("User '{}' attempts to access wallet address of space '{}'", new Object[]{modifier, space.getDisplayName()});
                throw new IllegalAccessException();
            }
            return false;
        }
        return true;
    }

    public static final void computeWalletFromIdentity(Wallet wallet, org.exoplatform.social.core.identity.model.Identity identity) {
        Space space;
        if (identity == null) {
            wallet.setDeletedUser(true);
            wallet.setEnabled(false);
            return;
        }
        WalletType walletType = WalletType.getType(identity.getProviderId());
        wallet.setId(identity.getRemoteId());
        wallet.setTechnicalId(Long.parseLong(identity.getId()));
        wallet.setDisabledUser(!identity.isEnable());
        wallet.setDeletedUser(identity.isDeleted());
        wallet.setType(walletType.getId());
        if (walletType.isUser() || walletType.isSpace()) {
            wallet.setAvatar(LinkProvider.buildAvatarURL((String)identity.getProviderId(), (String)identity.getRemoteId()));
        }
        if (walletType.isUser()) {
            wallet.setName(identity.getProfile().getFullName());
        } else if (walletType.isAdmin()) {
            if (StringUtils.equals((CharSequence)identity.getRemoteId(), (CharSequence)WALLET_ADMIN_REMOTE_ID)) {
                wallet.setName(PRINCIPAL_CONTRACT_ADMIN_NAME);
            }
        } else if (walletType.isSpace() && (space = WalletUtils.getSpace(identity.getRemoteId())) != null) {
            wallet.setName(space.getDisplayName());
            wallet.setSpaceId(Long.parseLong(space.getId()));
        }
    }

    public static final String formatTransactionHash(String transactionHash) {
        if (transactionHash == null) {
            return null;
        }
        if ((transactionHash = transactionHash.trim().toLowerCase()).length() == 64 && !transactionHash.startsWith("0x")) {
            transactionHash = "0x" + transactionHash;
        }
        if (transactionHash.length() != 66) {
            throw new IllegalStateException("Transaction hash " + transactionHash + " isn't well formatted. It should be of length 66");
        }
        if (!transactionHash.startsWith("0x")) {
            throw new IllegalStateException("Transaction hash " + transactionHash + " isn't well formatted. It should starts with 0x");
        }
        return transactionHash;
    }

    public static final void hideWalletOwnerPrivateInformation(Wallet wallet) {
        if (wallet == null) {
            return;
        }
        wallet.setPassPhrase(null);
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            JSON_PARSER.parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    public static final String toJsonString(Object object) {
        try {
            return JSON_GENERATOR.createJsonObject(object).toString();
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error parsing object to string " + object, e);
        }
    }

    public static final BigInteger convertToDecimals(double amount, int decimals) {
        return BigDecimal.valueOf(amount).multiply(BigDecimal.valueOf(10L).pow(decimals)).toBigInteger();
    }

    public static final double convertFromDecimals(BigInteger amount, int decimals) {
        return BigDecimal.valueOf(amount.doubleValue()).divide(BigDecimal.valueOf(10L).pow(decimals)).doubleValue();
    }

    public static final GlobalSettings getSettings() {
        return WalletUtils.getWalletService().getSettings();
    }

    public static final ContractDetail getContractDetail() {
        GlobalSettings settings = WalletUtils.getSettings();
        if (settings == null || settings.getContractDetail() == null) {
            throw new IllegalStateException("No principal contract address is configured");
        }
        return settings.getContractDetail();
    }

    public static final String getContractAddress() {
        GlobalSettings settings = WalletUtils.getSettings();
        if (settings == null || StringUtils.isBlank((CharSequence)settings.getContractAddress())) {
            throw new IllegalStateException("No principal contract address is configured");
        }
        return settings.getContractAddress();
    }

    public static final long getNetworkId() {
        GlobalSettings settings = WalletUtils.getSettings();
        return settings == null || settings.getNetwork() == null ? 0L : settings.getNetwork().getId();
    }

    public static final String getWebsocketURL() {
        GlobalSettings settings = WalletUtils.getSettings();
        return settings == null || settings.getNetwork() == null ? null : settings.getNetwork().getWebsocketProviderURL();
    }

    public static final String formatNumber(Object amount, String lang) {
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = Locale.getDefault().getLanguage();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(new Locale(lang));
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format(Double.parseDouble(amount.toString()));
    }

    public static final boolean hasKnownWalletInTransaction(TransactionDetail transactionDetail) {
        return !WalletUtils.isWalletEmpty(transactionDetail.getToWallet()) || !WalletUtils.isWalletEmpty(transactionDetail.getFromWallet()) || !WalletUtils.isWalletEmpty(transactionDetail.getByWallet());
    }

    public static final boolean isWalletEmpty(Wallet wallet) {
        return wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress());
    }

    public static final boolean isAdminAccount(String address) {
        if (WalletUtils.getWalletTokenAdminService() == null) {
            return false;
        }
        String adminWalletAddress = WalletUtils.getWalletTokenAdminService().getAdminWalletAddress();
        return StringUtils.equalsIgnoreCase((CharSequence)address, (CharSequence)adminWalletAddress);
    }

    public static final String getResourceBundleKey(Locale locale, String key) {
        String label;
        ResourceBundle resourceBundle = ((ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class)).getResourceBundle(RESOURCE_BUNDLE_NAME, locale);
        String string = label = resourceBundle == null ? null : resourceBundle.getString(key);
        if (StringUtils.isBlank((CharSequence)label)) {
            resourceBundle = ((ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class)).getResourceBundle(RESOURCE_BUNDLE_NAME, Locale.getDefault());
            label = resourceBundle == null ? null : resourceBundle.getString(key);
        }
        return label;
    }

    public static Locale getLocale(Wallet wallet) {
        Locale locale = null;
        locale = WalletType.isUser(wallet.getType()) ? WalletUtils.getUserLocale(wallet.getId()) : Locale.getDefault();
        return locale;
    }

    public static final Locale getUserLocale(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String lang;
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            UserProfile profile = null;
            try {
                profile = organizationService.getUserProfileHandler().findUserProfileByName(username);
            }
            catch (Exception e) {
                LOG.warn("Error getting profile of user {}", new Object[]{username, e});
            }
            if (profile != null && StringUtils.isNotBlank((CharSequence)(lang = profile.getAttribute("user.language")))) {
                return LocaleUtils.toLocale((String)lang);
            }
        }
        return Locale.getDefault();
    }

    private static final WalletTokenAdminService getWalletTokenAdminService() {
        return (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
    }

    private static final WalletService getWalletService() {
        return (WalletService)CommonsUtils.getService(WalletService.class);
    }

    private static final SpaceService getSpaceService() {
        return (SpaceService)CommonsUtils.getService(SpaceService.class);
    }
}

