/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.dao;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.entity.TransactionEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class WalletTransactionDAO
extends GenericDAOJPAImpl<TransactionEntity, Long> {
    private static final String HASH_PARAM = "hash";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String ADDRESS_PARAM = "address";
    private static final String CONTRACT_ADDRESS_PARAM = "contractAddress";
    private static final String CONTRACT_METHOD_NAME_PARAM = "methodName";
    private static final String NETWORK_ID_PARAM = "networkId";

    public List<TransactionEntity> getContractTransactions(String contractAddress, String contractMethodName, int limit) {
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        String queryName = "WalletTransaction.getContractTransactions";
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            queryName = "WalletTransaction.getContractTransactionsWithMethodName";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, TransactionEntity.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)contractAddress.toLowerCase());
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            query.setParameter(CONTRACT_METHOD_NAME_PARAM, (Object)contractMethodName);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<TransactionEntity> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, int limit, boolean onlyPending, boolean includeAdministrationTransactions) {
        address = StringUtils.lowerCase((String)address);
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        StringBuilder queryString = new StringBuilder("SELECT tx FROM WalletTransaction tx WHERE tx.networkId = ");
        queryString.append(networkId);
        if (!includeAdministrationTransactions) {
            queryString.append(" AND tx.isAdminOperation = FALSE");
        }
        queryString.append(" AND (tx.fromAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.toAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.byAddress = '");
        queryString.append(address);
        queryString.append("')");
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            queryString.append(" AND tx.contractMethodName = '");
            queryString.append(contractMethodName);
            queryString.append("'");
        }
        if (onlyPending) {
            queryString.append(" AND tx.isPending = TRUE");
        }
        if (StringUtils.isNotBlank((CharSequence)contractAddress)) {
            queryString.append(" AND tx.contractAddress = '");
            queryString.append(contractAddress);
            queryString.append("' ");
        }
        queryString.append(" ORDER BY tx.createdDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(queryString.toString(), TransactionEntity.class);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public Set<String> getPendingTransactionHashes(long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingTransactions", String.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        List results = query.getResultList();
        return results == null ? Collections.emptySet() : new HashSet(results);
    }

    public TransactionEntity getTransactionByHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getTransactionByHash", TransactionEntity.class);
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)hash));
        List resultList = query.getResultList();
        return resultList == null || resultList.isEmpty() ? null : (TransactionEntity)resultList.get(0);
    }

    public double countReceivedContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countReceivedContractAmount", Double.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)contractAddress));
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        query.setParameter(START_DATE, (Object)this.toMilliSeconds(startDate));
        query.setParameter(END_DATE, (Object)this.toMilliSeconds(endDate));
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countSentContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countSentContractAmount", Double.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)contractAddress));
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        query.setParameter(START_DATE, (Object)this.toMilliSeconds(startDate));
        query.setParameter(END_DATE, (Object)this.toMilliSeconds(endDate));
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    private long toMilliSeconds(ZonedDateTime date) {
        return date.toInstant().toEpochMilli();
    }
}

