/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.notification;

import java.util.ArrayList;
import java.util.Set;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardReport;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RewardSuccessNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(RewardSuccessNotificationPlugin.class);

    public RewardSuccessNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return "RewardSuccessNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Set recipients;
        RewardReport rewardReport = (RewardReport)ctx.value(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM);
        try {
            recipients = WalletUtils.getRewardAdministrators();
        }
        catch (Exception e) {
            LOG.error((Object)("Error making notification of reward report " + rewardReport), (Throwable)e);
            return null;
        }
        if (recipients == null || recipients.isEmpty()) {
            return null;
        }
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        RewardPeriod period = rewardReport.getPeriod();
        return NotificationInfo.instance().to(new ArrayList(recipients)).with("tokenName", contractDetail.getName()).with("symbol", contractDetail.getSymbol()).with("rewardPeriodType", period.getRewardPeriodType().name()).with("rewardStartPeriodDate", String.valueOf(period.getStartDateInSeconds())).with("rewardEndPeriodDate", String.valueOf(period.getEndDateInSeconds())).with("rewardSuccessCount", String.valueOf(rewardReport.getSuccessTransactionCount())).with("rewardFailCount", String.valueOf(rewardReport.getFailedTransactionCount())).with("rewardPendingCount", String.valueOf(rewardReport.getPendingTransactionCount())).with("rewardTransactionCount", String.valueOf(rewardReport.getTransactionsCount())).with("rewardValidMembersCount", String.valueOf(rewardReport.getValidRewardCount())).with("amount", String.valueOf(rewardReport.getTokensSent())).key(this.getKey()).end();
    }
}

