/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class ERTTokenV1
extends Contract {
    private static final String BINARY = "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";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_INITIALIZED = "initialized";
    public static final String FUNC_REMOVEADMIN = "removeAdmin";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";
    public static final String FUNC_VESTINGBALANCEOF = "vestingBalanceOf";
    public static final String FUNC_GETSELLPRICE = "getSellPrice";
    public static final String FUNC_ISADMIN = "isAdmin";
    public static final String FUNC_ADDADMIN = "addAdmin";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";
    public static final String FUNC_ISINITIALIZEDACCOUNT = "isInitializedAccount";
    public static final String FUNC_UPGRADEDATA = "upgradeData";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_GETDATAADDRESS = "getDataAddress";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";
    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";
    public static final String FUNC_ISPAUSED = "isPaused";
    public static final String FUNC_SETSYMBOL = "setSymbol";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_SETNAME = "setName";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_REWARDBALANCEOF = "rewardBalanceOf";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UNPAUSE = "unPause";
    public static final String FUNC_APPROVEACCOUNT = "approveAccount";
    public static final String FUNC_SETSELLPRICE = "setSellPrice";
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", Arrays.asList(new TypeReference[0]));
    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", Arrays.asList(new TypeReference[0]));
    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint8>(){}));
    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVE, Arrays.asList(new Address(_spender), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> initialized() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INITIALIZED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> removeAdmin(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVEADMIN, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> initialize(BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INITIALIZE, Arrays.asList(new Uint256(_initialAmount), new Utf8String(_tokenName), new Uint8(_decimalUnits), new Utf8String(_tokenSymbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(_from), new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEIMPLEMENTATION, Arrays.asList(new Address(_proxy), new Uint16(_version), new Address(_newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> vestingBalanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VESTINGBALANCEOF, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> getSellPrice() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETSELLPRICE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isAdmin(String _target, BigInteger _level) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> version() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> disapproveAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DISAPPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isInitializedAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISINITIALIZEDACCOUNT, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATA, Arrays.asList(new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> pause() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETDATAADDRESS, Arrays.asList(new Uint16(_version)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATAANDIMPLEMENTATION, Arrays.asList(new Address(_proxy), new Uint16(_version), new Address(_newImplementation), new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFER, Arrays.asList(new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isApprovedAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDACCOUNT, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<BigInteger> getAdminLevel(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETADMINLEVEL, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isPaused() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISPAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setSymbol(String _symbol) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSYMBOL, Arrays.asList(new Utf8String(_symbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setName(String _name) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETNAME, Arrays.asList(new Utf8String(_name)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _target, String _spender) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ALLOWANCE, Arrays.asList(new Address(_target), new Address(_spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> rewardBalanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REWARDBALANCEOF, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(_newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> unPause() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSELLPRICE, Arrays.asList(new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedEventResponse>(){

            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedDataEventResponse>(){

            public UpgradedDataEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADEDDATA_EVENT));
        return this.upgradedDataEventFlowable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TokenPriceChangedEventResponse>(){

            public TokenPriceChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TOKENPRICECHANGED_EVENT));
        return this.tokenPriceChangedEventFlowable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransactionFeeEventResponse>(){

            public TransactionFeeEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSACTIONFEE_EVENT));
        return this.transactionFeeEventFlowable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NoSufficientFundEventResponse>(){

            public NoSufficientFundEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NOSUFFICIENTFUND_EVENT));
        return this.noSufficientFundEventFlowable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DepositReceivedEventResponse>(){

            public DepositReceivedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSITRECEIVED_EVENT));
        return this.depositReceivedEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferEventResponse>(){

            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovedAccountEventResponse>(){

            public ApprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVEDACCOUNT_EVENT));
        return this.approvedAccountEventFlowable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DisapprovedAccountEventResponse>(){

            public DisapprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DISAPPROVEDACCOUNT_EVENT));
        return this.disapprovedAccountEventFlowable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ContractPausedEventResponse>(){

            public ContractPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTPAUSED_EVENT));
        return this.contractPausedEventFlowable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ContractUnPausedEventResponse>(){

            public ContractUnPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTUNPAUSED_EVENT));
        return this.contractUnPausedEventFlowable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, AddedAdminEventResponse>(){

            public AddedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDEDADMIN_EVENT));
        return this.addedAdminEventFlowable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, RemovedAdminEventResponse>(){

            public RemovedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REMOVEDADMIN_EVENT));
        return this.removedAdminEventFlowable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static class TransferOwnershipEventResponse {
        public Log log;
        public String newOwner;
    }

    public static class RemovedAdminEventResponse {
        public Log log;
        public String target;
    }

    public static class AddedAdminEventResponse {
        public Log log;
        public String target;
        public BigInteger level;
    }

    public static class ContractUnPausedEventResponse {
        public Log log;
    }

    public static class ContractPausedEventResponse {
        public Log log;
    }

    public static class DisapprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovalEventResponse {
        public Log log;
        public String _owner;
        public String _spender;
        public BigInteger _value;
    }

    public static class TransferEventResponse {
        public Log log;
        public String _from;
        public String _to;
        public BigInteger _value;
    }

    public static class DepositReceivedEventResponse {
        public Log log;
        public String from;
        public BigInteger amount;
    }

    public static class NoSufficientFundEventResponse {
        public Log log;
        public BigInteger balance;
    }

    public static class TransactionFeeEventResponse {
        public Log log;
        public String from;
        public BigInteger tokenFee;
        public BigInteger etherFeeRefund;
    }

    public static class TokenPriceChangedEventResponse {
        public Log log;
        public BigInteger tokenPrice;
    }

    public static class UpgradedDataEventResponse {
        public Log log;
        public BigInteger dataVersion;
        public String dataAddress;
    }

    public static class UpgradedEventResponse {
        public Log log;
        public BigInteger implementationVersion;
        public String implementationAddress;
    }
}

