/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.model.transaction.TransactionStatistics;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;

@Path(value="/wallet/api/transaction")
@RolesAllowed(value={"users"})
@Api(value="/wallet/api/transaction", description="Manages internally stored transactions")
public class WalletTransactionREST
implements ResourceContainer {
    private static final String EMPTY_ADDRESS_ERROR = "Bad request sent to server with empty address {}";
    private static final Log LOG = ExoLogger.getLogger(WalletTransactionREST.class);
    private BlockchainTransactionService blockchainTransactionService;
    private WalletTransactionService transactionService;
    private WalletTokenAdminService walletTokenAdminService;

    public WalletTransactionREST(WalletTransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @POST
    @Path(value="saveTransactionDetails")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Save transaction details in internal datasource", httpMethod="POST", response=Response.class, consumes="application/json", produces="application/json", notes="returns saved transaction detail")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveTransactionDetails(@ApiParam(value="transaction detail object", required=true) TransactionDetail transactionDetail) {
        if (transactionDetail == null || StringUtils.isBlank((String)transactionDetail.getFrom())) {
            LOG.warn("Bad request sent to server with empty transaction details: {}", new Object[]{transactionDetail == null ? "" : transactionDetail.toString()});
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        if (transactionDetail.getId() == 0L && StringUtils.isNotBlank((String)transactionDetail.getRawTransaction())) {
            String transactionHash = this.getWalletTokenAdminService().generateHash(transactionDetail.getRawTransaction());
            transactionDetail.setHash(transactionHash);
        } else {
            if (StringUtils.isBlank((String)transactionDetail.getHash())) {
                LOG.warn((Object)"Bad request sent to server with empty transaction hash");
                return Response.status((int)400).build();
            }
            transactionDetail.setSentTimestamp(System.currentTimeMillis());
        }
        try {
            this.transactionService.saveTransactionDetail(transactionDetail, currentUserId);
            return Response.ok((Object)transactionDetail).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is attempting to save transaction {}", new Object[]{currentUserId, transactionDetail, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Error saving transaction message {}", new Object[]{transactionDetail, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getSavedTransactionByHash")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get saved transaction in internal database by hash", httpMethod="GET", response=Response.class, produces="application/json", notes="returns transaction detail")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSavedTransactionByHash(@ApiParam(value="transaction hash", required=true) @QueryParam(value="hash") String hash) {
        if (StringUtils.isBlank((String)hash)) {
            LOG.warn("Empty transaction hash", new Object[]{hash});
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = this.transactionService.getTransactionByHash(hash, WalletUtils.getCurrentUserId());
            return Response.ok((Object)transactionDetail).build();
        }
        catch (Exception e) {
            LOG.error("Error getting transaction with hash {}", new Object[]{hash, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="getNonce")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get nonce to include in next transaction to send for a wallet", httpMethod="GET", response=Response.class, notes="returns transaction nonce")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNonce(@ApiParam(value="Transaction sender address", required=true) @QueryParam(value="from") String fromAddress) {
        if (StringUtils.isBlank((String)fromAddress)) {
            LOG.warn("Empty transaction sender", new Object[]{fromAddress});
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            long nonce = this.transactionService.getNonce(fromAddress, currentUser);
            return Response.ok((Object)String.valueOf(nonce)).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display last nonce of address {}", new Object[]{currentUser, fromAddress, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Error getting nonce for address {}", new Object[]{fromAddress, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactionsAmounts")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get token amounts sent per each period of time by a wallet identified by its address", httpMethod="GET", response=Response.class, produces="application/json", notes="returns transaction statistics object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTransactionsAmounts(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="periodicity : month or year", required=true) @QueryParam(value="periodicity") String periodicity, @ApiParam(value="Selected date", required=false) @QueryParam(value="date") String selectedDate, @ApiParam(value="user locale language", required=false) @QueryParam(value="lang") String lang) {
        if (StringUtils.isBlank((String)periodicity)) {
            LOG.warn((Object)"Bad request sent to server with empty periodicity parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        try {
            TransactionStatistics transactionStatistics = this.transactionService.getTransactionStatistics(address, periodicity, selectedDate, new Locale(lang));
            return Response.ok((Object)transactionStatistics).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions statistics of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactions")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get list of transactions of an address", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of transaction detail object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTransactions(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="token contract address to filter with", required=false) @QueryParam(value="contractAddress") String contractAddress, @ApiParam(value="token contract method to filter with", required=false) @QueryParam(value="contractMethodName") String contractMethodName, @ApiParam(value="transaction hash to include in response", required=false) @QueryParam(value="hash") String hash, @ApiParam(value="limit transactions to retrieve", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="whether to include only pending or not", required=false) @QueryParam(value="pending") boolean onlyPending, @ApiParam(value="whether to include administration transactions or not", required=false) @QueryParam(value="administration") boolean administration) {
        String currentUserId = WalletUtils.getCurrentUserId();
        try {
            List<TransactionDetail> transactionDetails = this.transactionService.getTransactions(address, contractAddress, contractMethodName, hash, limit, onlyPending, administration, currentUserId);
            return Response.ok(transactionDetails).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display transactions of address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="refreshTransactionFromBlockchain")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="refresh transaction detail from blockchain", httpMethod="GET", response=Response.class, produces="application/json", notes="return transaction detail refreshed from blockchain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response refreshTransactionFromBlockchain(@ApiParam(value="transaction hash", required=true) @QueryParam(value="hash") String hash) {
        if (StringUtils.isBlank((String)hash)) {
            LOG.warn((Object)"Bad request sent to server with empty transaction hash");
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = this.getBlockchainTransactionService().refreshTransactionFromBlockchain(hash);
            return Response.ok((Object)transactionDetail).build();
        }
        catch (Exception e) {
            LOG.error("Error refreshing transaction with hash {} from blockchain", new Object[]{hash, e});
            return Response.serverError().build();
        }
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }

    public BlockchainTransactionService getBlockchainTransactionService() {
        if (this.blockchainTransactionService == null) {
            this.blockchainTransactionService = (BlockchainTransactionService)CommonsUtils.getService(BlockchainTransactionService.class);
        }
        return this.blockchainTransactionService;
    }
}

