/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.util.Map;
import java.util.Set;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletAddressLabel;
import org.exoplatform.wallet.model.WalletInitializationState;

public interface WalletAccountService {
    public Set<Wallet> listWallets();

    public long getWalletsCount();

    public Wallet getWalletByIdentityId(long var1);

    public Wallet getWalletByTypeAndId(String var1, String var2, String var3);

    public Wallet getWalletByTypeAndId(String var1, String var2);

    public Wallet getAdminWallet();

    public void savePrivateKeyByTypeAndId(String var1, String var2, String var3, String var4) throws IllegalAccessException;

    public String getPrivateKeyByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public String getPrivateKeyByTypeAndId(String var1, String var2);

    public void removePrivateKeyByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public Wallet getWalletByAddress(String var1, String var2);

    public Wallet getWalletByAddress(String var1);

    public void saveWalletBlockchainState(Wallet var1, String var2);

    public Wallet saveWalletBackupState(String var1, long var2, boolean var4) throws IllegalAccessException;

    public void saveWalletAddress(Wallet var1, String var2) throws IllegalAccessException;

    public Wallet saveWallet(Wallet var1, boolean var2);

    public void removeWalletByAddress(String var1, String var2) throws IllegalAccessException;

    public void removeWalletByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public boolean enableWalletByAddress(String var1, boolean var2, String var3) throws IllegalAccessException;

    public boolean isWalletOwner(Wallet var1, String var2);

    public WalletAddressLabel saveOrDeleteAddressLabel(WalletAddressLabel var1, String var2);

    public Set<WalletAddressLabel> getAddressesLabelsVisibleBy(String var1);

    public void setInitializationStatus(String var1, WalletInitializationState var2, String var3) throws IllegalAccessException;

    public void setInitializationStatus(String var1, WalletInitializationState var2);

    public void createAdminAccount(String var1, String var2) throws IllegalAccessException;

    public String getAdminAccountPassword();

    public void refreshWalletsFromBlockchain(Map<String, Set<String>> var1);

    public void refreshWalletFromBlockchain(Wallet var1, ContractDetail var2, Map<String, Set<String>> var3);

    public void retrieveWalletBlockchainState(Wallet var1);

    public boolean isAdminAccountEnabled();
}

