/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.utils.RewardUtils;

public enum RewardPeriodType {
    WEEK,
    MONTH,
    QUARTER,
    SEMESTER,
    YEAR;

    public static final RewardPeriodType DEFAULT;

    public RewardPeriod getPeriodOfTime(LocalDateTime localDateTime) {
        RewardPeriod rewardPeriod = new RewardPeriod(this);
        YearMonth yearMonth = YearMonth.from(localDateTime);
        switch (this) {
            case WEEK: {
                LocalDateTime firstDayOfThisWeek = localDateTime.with(DayOfWeek.MONDAY);
                LocalDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfThisWeek));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfNextWeek));
                break;
            }
            case MONTH: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(currentMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(nextMonth.atDay(1).atStartOfDay()));
                break;
            }
            case QUARTER: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(startQuarterMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(endQuarterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case SEMESTER: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(startSemesterMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(endSemesterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case YEAR: {
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(Year.from(localDateTime).atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(Year.from(localDateTime).plusYears(1L).atDay(1).atStartOfDay()));
            }
        }
        return rewardPeriod;
    }

    static {
        DEFAULT = MONTH;
    }
}

