/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.WalletReward;

public class RewardReport {
    private RewardPeriod period = null;
    private Set<WalletReward> rewards = new HashSet<WalletReward>();

    public long getPendingTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((String)rewardItem.getStatus(), (String)"pending")).count();
    }

    public long getSuccessTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((String)rewardItem.getStatus(), (String)"success")).count();
    }

    public long getFailedTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((String)rewardItem.getStatus(), (String)"error")).count();
    }

    public long getTransactionsCount() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null).count();
    }

    public Set<WalletReward> getValidRewards() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0.0).collect(Collectors.toSet());
    }

    public double getRemainingTokensToSend() {
        return this.rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensSent() == 0.0 ? rewardItem.getTokensToSend() : 0.0).sum();
    }

    public long getValidRewardCount() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTokensToSend() > 0.0).count();
    }

    public double getTokensToSend() {
        return this.rewards.stream().mapToDouble(WalletReward::getTokensToSend).sum();
    }

    public double getTokensSent() {
        return this.rewards.stream().mapToDouble(WalletReward::getTokensSent).sum();
    }

    public boolean hasSuccessTransactions() {
        return this.getSuccessTransactionCount() > 0L;
    }

    public boolean hasPendingTransactions() {
        return this.getPendingTransactionCount() > 0L;
    }

    public boolean hasErrorTransactions() {
        return this.getFailedTransactionCount() > 0L;
    }

    public boolean isCompletelyProceeded() {
        return this.getTransactionsCount() > 0L && this.getSuccessTransactionCount() >= this.getValidRewardCount();
    }

    public RewardPeriod getPeriod() {
        return this.period;
    }

    public Set<WalletReward> getRewards() {
        return this.rewards;
    }

    public void setPeriod(RewardPeriod period) {
        this.period = period;
    }

    public void setRewards(Set<WalletReward> rewards) {
        this.rewards = rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardReport)) {
            return false;
        }
        RewardReport other = (RewardReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RewardPeriod this$period = this.getPeriod();
        RewardPeriod other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Set<WalletReward> this$rewards = this.getRewards();
        Set<WalletReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RewardReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RewardPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Set<WalletReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "RewardReport(period=" + this.getPeriod() + ", rewards=" + this.getRewards() + ")";
    }
}

