/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.job;

import java.util.Iterator;
import java.util.Set;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardReport;
import org.exoplatform.addon.wallet.reward.service.RewardService;
import org.exoplatform.addon.wallet.reward.service.RewardSettingsService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardStatusVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(RewardStatusVerifierJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private RewardSettingsService rewardSettingsService;
    private RewardService rewardService;
    private ListenerService listenerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Set rewardPeriodsInProgress = this.getRewardSettingsService().getRewardPeriodsInProgress();
            if (rewardPeriodsInProgress != null && !rewardPeriodsInProgress.isEmpty()) {
                Iterator rewardPeriodsIterator = rewardPeriodsInProgress.iterator();
                boolean changed = false;
                while (rewardPeriodsIterator.hasNext()) {
                    RewardPeriod rewardPeriod = (RewardPeriod)rewardPeriodsIterator.next();
                    RewardReport rewardReport = this.getRewardService().getRewardReport(rewardPeriod.getStartDateInSeconds());
                    if (rewardReport == null) continue;
                    if (rewardReport.isCompletelyProceeded()) {
                        LOG.debug("Rewards sent successfully for period {}: wallets to reward = {} ,transactions = {} , success = {}, failed = {}, pending = {}, completed = {}", new Object[]{rewardPeriod.getStartDateInSeconds(), rewardReport.countValidRewards(), rewardReport.countTransactions(), rewardReport.countSuccess(), rewardReport.countFailed(), rewardReport.countPending(), rewardReport.isCompletelyProceeded()});
                        this.getListenerService().broadcast("exo.wallet.reward.report.success", (Object)rewardReport, null);
                        changed = true;
                        rewardPeriodsIterator.remove();
                        continue;
                    }
                    LOG.debug("Reward always in progree for period {}: wallets to reward = {} ,transactions = {} , success = {}, failed = {}, pending = {}, completed = {}", new Object[]{rewardPeriod.getStartDateInSeconds(), rewardReport.countValidRewards(), rewardReport.countTransactions(), rewardReport.countSuccess(), rewardReport.countFailed(), rewardReport.countPending(), rewardReport.isCompletelyProceeded()});
                }
                if (changed) {
                    this.getRewardSettingsService().saveRewardPeriodInProgress(rewardPeriodsInProgress);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending rewards", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private RewardSettingsService getRewardSettingsService() {
        if (this.rewardSettingsService == null) {
            this.rewardSettingsService = (RewardSettingsService)CommonsUtils.getService(RewardSettingsService.class);
        }
        return this.rewardSettingsService;
    }

    private RewardService getRewardService() {
        if (this.rewardService == null) {
            this.rewardService = (RewardService)CommonsUtils.getService(RewardService.class);
        }
        return this.rewardService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

