/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.listener;

import org.exoplatform.addon.wallet.model.reward.RewardReport;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class RewardSucceedNotificationListener
extends Listener<RewardReport, Object> {
    private static final Log LOG = ExoLogger.getLogger(RewardSucceedNotificationListener.class);
    private ExoContainer container;

    public RewardSucceedNotificationListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<RewardReport, Object> event) throws Exception {
        RewardReport rewardReport = (RewardReport)event.getSource();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.sendNotification(rewardReport);
        }
        catch (Exception e) {
            LOG.error("Error processing transaction notification {}", new Object[]{event.getData(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void sendNotification(RewardReport rewardReport) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)rewardReport);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RewardSuccessNotificationPlugin"))).execute(ctx);
    }
}

