/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.reward.RewardTransaction;
import org.exoplatform.addon.wallet.reward.service.RewardTransactionService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.social.core.identity.model.Identity;

public class WalletRewardTransactionService
implements RewardTransactionService {
    private SettingService settingService;

    public WalletRewardTransactionService(SettingService settingService) {
        this.settingService = settingService;
    }

    public List<RewardTransaction> getRewardTransactions(String periodType, long startDateInSeconds) {
        String periodTransactionsParamName = this.getPeriodTransactionsParamName(periodType, startDateInSeconds);
        SettingValue periodTransactionsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, periodTransactionsParamName);
        String periodTransactionsString = periodTransactionsValue == null ? "" : periodTransactionsValue.getValue().toString();
        String[] periodTransactionsArray = periodTransactionsString.isEmpty() ? new String[]{} : periodTransactionsString.split(",");
        return Arrays.stream(periodTransactionsArray).map(transaction -> {
            RewardTransaction rewardTransaction = RewardTransaction.fromStoredValue((String)transaction);
            Identity receiverIdentity = null;
            receiverIdentity = rewardTransaction.getReceiverIdentityId() > 0L ? WalletUtils.getIdentityById((long)rewardTransaction.getReceiverIdentityId()) : WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.getType((String)rewardTransaction.getReceiverType()), (String)rewardTransaction.getReceiverId());
            long receiverIdentityId = receiverIdentity == null ? 0L : Long.parseLong(receiverIdentity.getId());
            rewardTransaction.setReceiverIdentityId(receiverIdentityId);
            return rewardTransaction;
        }).collect(Collectors.toList());
    }

    public void saveRewardTransaction(RewardTransaction rewardTransaction) {
        String rewardPeriodTransactionsParamName;
        SettingValue periodTransactionsValue;
        String rewardPeriodTransactionsString;
        if (rewardTransaction == null) {
            throw new IllegalArgumentException("rewardTransaction parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getHash())) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        if (StringUtils.isBlank((String)rewardTransaction.getPeriodType())) {
            throw new IllegalArgumentException("transaction PeriodType parameter is mandatory");
        }
        if (rewardTransaction.getStartDateInSeconds() == 0L) {
            throw new IllegalArgumentException("transaction 'period start date' parameter is mandatory");
        }
        if (rewardTransaction.getReceiverIdentityId() == 0L) {
            if (StringUtils.isBlank((String)rewardTransaction.getReceiverType())) {
                throw new IllegalArgumentException("transaction ReceiverType parameter is mandatory");
            }
            if (StringUtils.isBlank((String)rewardTransaction.getReceiverId())) {
                throw new IllegalArgumentException("transaction ReceiverId parameter is mandatory");
            }
        }
        String string = rewardPeriodTransactionsString = (periodTransactionsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, rewardPeriodTransactionsParamName = this.getPeriodTransactionsParamName(rewardTransaction.getPeriodType(), rewardTransaction.getStartDateInSeconds()))) == null ? "" : periodTransactionsValue.getValue().toString();
        if (!rewardPeriodTransactionsString.contains(rewardTransaction.getHash())) {
            String contentToPrepend = rewardTransaction.getToStoreValue();
            rewardPeriodTransactionsString = rewardPeriodTransactionsString.isEmpty() ? contentToPrepend : contentToPrepend + "," + rewardPeriodTransactionsString;
            this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, rewardPeriodTransactionsParamName, SettingValue.create((String)rewardPeriodTransactionsString));
        }
    }

    private String getPeriodTransactionsParamName(String periodType, long startDateInSeconds) {
        return periodType + startDateInSeconds;
    }
}

