/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.wallet.reward.entity.WalletRewardPluginEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RewardPluginDAO
extends GenericDAOJPAImpl<WalletRewardPluginEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(RewardPluginDAO.class);

    public List<WalletRewardPluginEntity> findRewardPluginsByPeriodId(long rewardId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPlugin.getRewardPluginsByRewardId", WalletRewardPluginEntity.class);
        query.setParameter("rewardId", (Object)rewardId);
        return query.getResultList();
    }

    public WalletRewardPluginEntity findRewardPluginByRewardIdAndPlugin(long rewardId, String pluginId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPlugin.getRewardPluginsByRewardId", WalletRewardPluginEntity.class);
        query.setParameter("rewardId", (Object)rewardId);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one reward plugin was found for rewardId {} and pluginId {}", new Object[]{rewardId, pluginId});
        }
        return (WalletRewardPluginEntity)result.get(0);
    }
}

