/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.scheduled;

import java.time.Duration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.web3j.protocol.core.methods.response.Transaction;

@DisallowConcurrentExecution
public class PendingTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(PendingTransactionVerifierJob.class);
    private EthereumClientConnector ethereumClientConnector;
    private WalletTransactionService transactionService;
    private ListenerService listenerService;
    private ExoContainer container;

    public PendingTransactionVerifierJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public PendingTransactionVerifierJob(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            List pendingTransactions = this.getTransactionService().getPendingTransactions();
            if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
                LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database", new Object[]{pendingTransactions.size()});
                long pendingTransactionMaxDays = this.getTransactionService().getPendingTransactionMaxDays();
                for (TransactionDetail pendingTransactionDetail : pendingTransactions) {
                    try {
                        this.verifyTransactionStatusOnBlockchain(pendingTransactionDetail, pendingTransactionMaxDays);
                    }
                    catch (Exception e) {
                        LOG.warn("Error treating pending transaction: {}", new Object[]{pendingTransactionDetail, e});
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private void verifyTransactionStatusOnBlockchain(TransactionDetail pendingTransactionDetail, long pendingTransactionMaxDays) throws Exception {
        String blockHash;
        String hash = pendingTransactionDetail.getHash();
        Transaction transaction = this.getEthereumClientConnector().getTransaction(hash);
        String string = blockHash = transaction == null ? null : transaction.getBlockHash();
        if (!StringUtils.isBlank((String)blockHash) && !StringUtils.equalsIgnoreCase((String)"0x0000000000000000000000000000000000000000000000000000000000000000", (String)blockHash) && transaction.getBlockNumber() != null) {
            this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
        } else if (pendingTransactionMaxDays > 0L) {
            Duration duration;
            long creationTimestamp = pendingTransactionDetail.getTimestamp();
            if (transaction == null && creationTimestamp > 0L && (duration = Duration.ofMillis(System.currentTimeMillis() - creationTimestamp)).toDays() >= pendingTransactionMaxDays) {
                LOG.info("Transaction '{}' was not found on blockchain for more than '{}' days, so mark it as failed", new Object[]{hash, pendingTransactionMaxDays});
                this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)hash, null);
            }
        }
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

