/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.listener;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class WalletStateListener
extends Listener<Wallet, String> {
    private static final Log LOG = ExoLogger.getLogger(WalletStateListener.class);

    /*
     * Enabled aggressive block sorting
     */
    public void onEvent(Event<Wallet, String> event) throws Exception {
        String issuer = (String)event.getData();
        Wallet wallet = (Wallet)event.getSource();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("", wallet);
        parameters.put("local_service", "wallet");
        String eventName = event.getEventName();
        if (StringUtils.equals((CharSequence)"exo.addon.wallet.enabled", (CharSequence)eventName)) {
            parameters.put("operation", "enable");
        } else if (StringUtils.equals((CharSequence)"exo.addon.wallet.disabled", (CharSequence)eventName)) {
            parameters.put("operation", "disable");
        } else {
            if (!StringUtils.equals((CharSequence)"exo.addon.wallet.initialization.state", (CharSequence)eventName)) {
                LOG.warn("Event name not handled: {}", new Object[]{eventName});
                return;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)wallet.getInitializationState(), (CharSequence)WalletInitializationState.DENIED.name())) {
                LOG.debug("Wallet state modification not handeled: {}", new Object[]{wallet.getInitializationState()});
                return;
            }
            parameters.put("operation", "reject");
        }
        parameters.put("status", "ok");
        parameters.put("status_code", "200");
        parameters.put("duration_ms", "");
        if (StringUtils.isNotBlank((CharSequence)issuer)) {
            Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)issuer);
            if (identity == null) {
                LOG.warn((Object)("Can't find identity with remote id: {}" + issuer));
            } else {
                parameters.put("user_social_id", identity);
            }
        }
        StatisticUtils.addStatisticEntry(parameters);
    }
}

