/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.listener;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.model.transaction.TransactionNotificationType;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class TransactionNotificationListener
extends Listener<Object, Map<String, Object>> {
    private static final Log LOG = ExoLogger.getLogger(TransactionNotificationListener.class);
    private ExoContainer container;
    private WalletTransactionService transactionService;
    private WalletAccountService walletAccountService;

    public TransactionNotificationListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Map<String, Object>> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String contractAdminAddress;
            String transactionHash = (String)((Map)event.getData()).get("hash");
            if (StringUtils.isBlank((String)transactionHash)) {
                return;
            }
            TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
            if (transactionDetail == null || !transactionDetail.isSucceeded()) {
                return;
            }
            this.logStatistics(transactionDetail);
            if (transactionDetail.isAdminOperation()) {
                return;
            }
            Wallet senderWallet = null;
            String senderAddress = transactionDetail.getFrom();
            GlobalSettings settings = WalletUtils.getSettings();
            ContractDetail contractDetail = settings.getContractDetail();
            String string = contractAdminAddress = contractDetail == null ? null : contractDetail.getOwner();
            if (StringUtils.isNotBlank((String)senderAddress) && (senderWallet = this.getWalletAccountService().getWalletByAddress(senderAddress)) == null) {
                senderWallet = new Wallet();
                senderWallet.setAddress(senderAddress);
                senderWallet.setAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                if (StringUtils.isNotBlank((String)contractAdminAddress) && StringUtils.equalsIgnoreCase((String)contractAdminAddress, (String)senderAddress)) {
                    senderWallet.setName("Admin");
                } else {
                    senderWallet.setName(senderAddress);
                }
            }
            Wallet receiverWallet = null;
            String receiverAddress = transactionDetail.getTo();
            if (StringUtils.isNotBlank((String)receiverAddress) && (receiverWallet = this.getWalletAccountService().getWalletByAddress(receiverAddress)) == null) {
                receiverWallet = new Wallet();
                receiverWallet.setAddress(receiverAddress);
                receiverWallet.setAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                if (StringUtils.isNotBlank((String)contractAdminAddress) && StringUtils.equalsIgnoreCase((String)contractAdminAddress, (String)receiverAddress)) {
                    receiverWallet.setName("Admin");
                } else {
                    receiverWallet.setName(receiverAddress);
                }
            }
            if (senderWallet != null && senderWallet.getTechnicalId() > 0L && senderWallet.isEnabled() && !senderWallet.isDeletedUser() && !senderWallet.isDisabledUser()) {
                this.sendNotification(transactionDetail, TransactionNotificationType.SENDER, senderWallet, receiverWallet, settings);
            }
            if (receiverWallet != null && receiverWallet.getTechnicalId() > 0L && receiverWallet.isEnabled() && !receiverWallet.isDeletedUser() && !receiverWallet.isDisabledUser()) {
                this.sendNotification(transactionDetail, TransactionNotificationType.RECEIVER, senderWallet, receiverWallet, settings);
            }
        }
        catch (Exception e) {
            LOG.error("Error processing transaction notification {}", new Object[]{event.getData(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void sendNotification(TransactionDetail transactionDetail, TransactionNotificationType transactionStatus, Wallet senderWallet, Wallet receiverWallet, GlobalSettings settings) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(WalletUtils.HASH_PARAMETER, (Object)transactionDetail.getHash());
        ctx.append(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)senderWallet);
        ctx.append(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)receiverWallet);
        ctx.append(WalletUtils.MESSAGE_PARAMETER, (Object)(transactionDetail.getMessage() == null ? "" : transactionDetail.getMessage()));
        if (StringUtils.isBlank((String)transactionDetail.getContractAddress())) {
            ctx.append(WalletUtils.SYMBOL_PARAMETER, (Object)"ether");
            ctx.append(WalletUtils.CONTRACT_ADDRESS_PARAMETER, (Object)"");
            ctx.append(WalletUtils.AMOUNT_PARAMETER, (Object)transactionDetail.getValue());
        } else {
            ContractDetail contractDetail = settings.getContractDetail();
            ctx.append(WalletUtils.SYMBOL_PARAMETER, (Object)contractDetail.getSymbol());
            ctx.append(WalletUtils.CONTRACT_ADDRESS_PARAMETER, (Object)contractDetail.getAddress());
            ctx.append(WalletUtils.AMOUNT_PARAMETER, (Object)transactionDetail.getContractAmount());
        }
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)transactionStatus.getNotificationId()))).execute(ctx);
    }

    private void logStatistics(TransactionDetail transactionDetail) {
        String contractMethodName = transactionDetail.getContractMethodName();
        if (StringUtils.isBlank((String)contractMethodName)) {
            contractMethodName = "ether_transfer";
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("local_service", "wallet");
        parameters.put("operation", contractMethodName);
        if (transactionDetail.getIssuer() != null) {
            parameters.put("user_social_id", transactionDetail.getIssuer().getTechnicalId());
        }
        parameters.put("sender", transactionDetail.getFromWallet());
        parameters.put("receiver", transactionDetail.getToWallet());
        switch (contractMethodName) {
            case "initializeAccount": {
                parameters.put("operation", "initialize_account");
                parameters.put("amount_ether", transactionDetail.getValue());
                parameters.put("amount_token", transactionDetail.getContractAmount());
                break;
            }
            case "ether_transfer": 
            case "transfer": 
            case "transferFrom": 
            case "approve": {
                parameters.put("amount_ether", transactionDetail.getValue());
                parameters.put("amount_token", transactionDetail.getContractAmount());
                break;
            }
            case "reward": {
                parameters.put("amount_token", transactionDetail.getContractAmount());
                break;
            }
            case "addAdmin": {
                parameters.put("admin_level", transactionDetail.getValue());
                break;
            }
        }
        parameters.put("transaction", transactionDetail.getHash());
        parameters.put("status", transactionDetail.isSucceeded() ? "ok" : "ko");
        parameters.put("status_code", transactionDetail.isSucceeded() ? "200" : "500");
        StatisticUtils.addStatisticEntry(parameters);
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.walletAccountService;
    }
}

