/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.util.Collection;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.WebSocketMessage;
import org.exoplatform.wallet.utils.WalletUtils;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class WalletWebSocketService {
    private static final Log LOG = ExoLogger.getLogger(WalletWebSocketService.class);
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private String cometdContextName;

    public void sendMessage(String eventId, Collection<String> recipientUsers, boolean sendToAll, Object ... objects) {
        this.getContinuationService();
        WebSocketMessage messageObject = new WebSocketMessage(eventId, objects);
        String message = WalletUtils.toJsonString((Object)messageObject);
        if (sendToAll) {
            this.continuationService.sendBroadcastMessage("/eXo/Application/Addons/Wallet", (Object)message);
        } else if (recipientUsers != null && !recipientUsers.isEmpty()) {
            for (String recipientUser : recipientUsers) {
                if (!this.continuationService.isPresent(recipientUser)) continue;
                this.continuationService.sendMessage(recipientUser, "/eXo/Application/Addons/Wallet", (Object)message);
            }
        }
    }

    protected String getCometdContextName() {
        if (this.cometdContextName == null) {
            this.getContinuationBayeux();
            this.cometdContextName = this.continuationBayeux == null ? "cometd" : this.continuationBayeux.getCometdContextName();
        }
        return this.cometdContextName;
    }

    protected String getUserToken(String username) {
        try {
            if (this.getContinuationService() != null) {
                return this.getContinuationService().getUserToken(username);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
        }
        return "";
    }

    private EXoContinuationBayeux getContinuationBayeux() {
        if (this.continuationBayeux == null) {
            this.continuationBayeux = (EXoContinuationBayeux)CommonsUtils.getService(EXoContinuationBayeux.class);
        }
        return this.continuationBayeux;
    }

    private ContinuationService getContinuationService() {
        if (this.continuationService == null) {
            this.continuationService = (ContinuationService)CommonsUtils.getService(ContinuationService.class);
        }
        return this.continuationService;
    }
}

