/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletTransactionService;

public class TransactionCreatedListener
extends Listener<Object, TransactionDetail> {
    private ListenerService listenerService;
    private WalletTransactionService transactionService;

    public TransactionCreatedListener(ListenerService listenerService, WalletTransactionService transactionService) {
        this.listenerService = listenerService;
        this.transactionService = transactionService;
    }

    public void onEvent(Event<Object, TransactionDetail> event) throws Exception {
        TransactionDetail transactionDetail = (TransactionDetail)event.getData();
        this.transactionService.cancelTransactionsWithSameNonce(transactionDetail);
        if (StringUtils.isBlank((CharSequence)transactionDetail.getRawTransaction()) && transactionDetail.isPending()) {
            this.listenerService.broadcast("exo.wallet.transaction.sent", (Object)transactionDetail, (Object)transactionDetail);
        }
    }
}

