/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.job;

import java.util.Arrays;
import org.exoplatform.wallet.job.PendingEtherTransactionVerifierJob;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PendingEtherTransactionVerifierJobTest
extends BaseWalletTest {
    private static final String ADDRESS = "address";
    @Mock
    WalletTransactionService walletTransactionService;
    @Mock
    BlockchainTransactionService blockchainTransactionService;
    @Mock
    WalletAccountService walletAccountService;
    PendingEtherTransactionVerifierJob etherTransactionVerifierJob;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.etherTransactionVerifierJob = new PendingEtherTransactionVerifierJob();
        this.etherTransactionVerifierJob.blockchainTransactionService = this.blockchainTransactionService;
        this.etherTransactionVerifierJob.walletTransactionService = this.walletTransactionService;
        this.etherTransactionVerifierJob.walletAccountService = this.walletAccountService;
    }

    @Test
    public void testRunJobWithNoAdminWallet() throws Exception {
        this.etherTransactionVerifierJob.execute(null);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.never())).getPendingEtherTransactions((String)ArgumentMatchers.any());
    }

    @Test
    public void testRunJobWithExceptionDoesntExit() throws Exception {
        ((WalletAccountService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("FAKE EXCEPTION")}).when((Object)this.walletAccountService)).getAdminWallet();
        this.etherTransactionVerifierJob.execute(null);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.never())).getPendingEtherTransactions((String)ArgumentMatchers.any());
    }

    @Test
    public void testRunJobWithEmptyTransactions() throws Exception {
        Wallet adminWallet = new Wallet();
        adminWallet.setAddress(ADDRESS);
        Mockito.when((Object)this.walletAccountService.getAdminWallet()).thenReturn((Object)adminWallet);
        this.etherTransactionVerifierJob.execute(null);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).getPendingEtherTransactions(ADDRESS);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.never())).addTransactionToRefreshFromBlockchain((TransactionDetail)ArgumentMatchers.any());
    }

    @Test
    public void testRunJobWithPendingTransactions() throws Exception {
        Wallet adminWallet = new Wallet();
        adminWallet.setAddress(ADDRESS);
        Mockito.when((Object)this.walletAccountService.getAdminWallet()).thenReturn((Object)adminWallet);
        Mockito.when((Object)this.walletTransactionService.getPendingEtherTransactions(ADDRESS)).thenReturn(Arrays.asList(new TransactionDetail(), new TransactionDetail(), new TransactionDetail()));
        this.etherTransactionVerifierJob.execute(null);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)3))).addTransactionToRefreshFromBlockchain((TransactionDetail)ArgumentMatchers.any());
    }

    @Test
    public void testRunJobWithPendingTransactionsNoInterruptWhenException() throws Exception {
        Wallet adminWallet = new Wallet();
        adminWallet.setAddress(ADDRESS);
        Mockito.when((Object)this.walletAccountService.getAdminWallet()).thenReturn((Object)adminWallet);
        TransactionDetail transactionDetail1 = new TransactionDetail();
        transactionDetail1.setId(1L);
        TransactionDetail transactionDetail2 = new TransactionDetail();
        transactionDetail2.setId(2L);
        TransactionDetail transactionDetail3 = new TransactionDetail();
        transactionDetail3.setId(3L);
        Mockito.when((Object)this.walletTransactionService.getPendingEtherTransactions(ADDRESS)).thenReturn(Arrays.asList(transactionDetail1, transactionDetail2, transactionDetail3));
        ((BlockchainTransactionService)Mockito.doThrow(RuntimeException.class).when((Object)this.blockchainTransactionService)).addTransactionToRefreshFromBlockchain(transactionDetail1);
        this.etherTransactionVerifierJob.execute(null);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)3))).addTransactionToRefreshFromBlockchain((TransactionDetail)ArgumentMatchers.any());
    }
}

