/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.dao;

import java.util.List;
import org.exoplatform.wallet.dao.WalletAccountDAO;
import org.exoplatform.wallet.dao.WalletBlockchainStateDAO;
import org.exoplatform.wallet.entity.WalletBlockchainStateEntity;
import org.exoplatform.wallet.entity.WalletEntity;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Test;

public class WalletBlockchainStateDAOTest
extends BaseWalletTest {
    @Test
    public void testServiceInstantiated() {
        WalletBlockchainStateDAO walletBlockchainStateDAO = this.getService(WalletBlockchainStateDAO.class);
        List allStates = walletBlockchainStateDAO.findAll();
        WalletBlockchainStateDAOTest.assertNotNull((String)"Returned states shouldn't be null", (Object)allStates);
        WalletBlockchainStateDAOTest.assertEquals((String)"Returned states list should be empty", (int)0, (int)allStates.size());
    }

    @Test
    public void testGetContractTransactions() {
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        WalletBlockchainStateDAO walletBlockchainStateDAO = this.getService(WalletBlockchainStateDAO.class);
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        WalletEntity walletEntity = new WalletEntity();
        String address = "0xc76987D43b77C45d51653b6eB110b9174aCCE8fb";
        walletEntity.setId(Long.valueOf(1L));
        walletEntity.setAddress(address);
        walletEntity.setPassPhrase("passphrase");
        walletEntity.setType(WalletType.USER);
        walletEntity = (WalletEntity)walletAccountDAO.create((Object)walletEntity);
        this.entitiesToClean.add(walletEntity);
        WalletBlockchainStateEntity blockchainStateEntity = new WalletBlockchainStateEntity();
        blockchainStateEntity.setContractAddress(contractAddress);
        blockchainStateEntity.setWallet(walletEntity);
        WalletBlockchainStateEntity blockchainStateEntity1 = (WalletBlockchainStateEntity)walletBlockchainStateDAO.create((Object)blockchainStateEntity);
        this.entitiesToClean.add(blockchainStateEntity1);
        blockchainStateEntity = new WalletBlockchainStateEntity();
        blockchainStateEntity.setContractAddress(contractAddress);
        blockchainStateEntity.setWallet(walletEntity);
        WalletBlockchainStateEntity blockchainStateEntity2 = (WalletBlockchainStateEntity)walletBlockchainStateDAO.create((Object)blockchainStateEntity);
        this.entitiesToClean.add(blockchainStateEntity2);
        blockchainStateEntity = walletBlockchainStateDAO.findByWalletIdAndContract(walletEntity.getId().longValue(), contractAddress);
        WalletBlockchainStateDAOTest.assertNotNull((String)"Can't find wallet state", (Object)blockchainStateEntity);
        WalletBlockchainStateDAOTest.assertEquals((Object)blockchainStateEntity2.getId(), (Object)blockchainStateEntity.getId());
    }
}

