/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.model.transaction.MinedTransactionDetail;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class BlockchainTransactionProcessorListener
extends Listener<Object, TransactionReceipt> {
    private static final Log LOG = ExoLogger.getLogger(BlockchainTransactionProcessorListener.class);
    private WalletTransactionService transactionService;
    private BlockchainTransactionService transactionDecoder;
    private EthereumClientConnector ethereumClientConnector;
    private ExoContainer container;

    public BlockchainTransactionProcessorListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, TransactionReceipt> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            MinedTransactionDetail transaction;
            Object source = event.getSource();
            if (source == null) {
                return;
            }
            TransactionDetail transactionDetail = null;
            String transactionHash = null;
            String blockHash = null;
            Long blockTimestamp = null;
            if (source instanceof MinedTransactionDetail) {
                transaction = (MinedTransactionDetail)source;
                transactionHash = transaction.getHash();
                blockHash = transaction.getBlockHash();
                blockTimestamp = transaction.getBlockTimestamp();
            } else if (source instanceof Transaction) {
                transaction = (Transaction)source;
                transactionHash = transaction.getHash();
                blockHash = transaction.getBlockHash();
            } else if (source instanceof TransactionDetail) {
                transactionDetail = (TransactionDetail)source;
                transactionHash = transactionDetail.getHash();
            } else {
                transactionHash = (String)source;
            }
            if (StringUtils.isBlank((CharSequence)transactionHash)) {
                LOG.warn((Object)"Transaction hash is empty");
                return;
            }
            if (transactionDetail == null) {
                transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
            }
            if (transactionDetail == null) {
                LOG.warn("Transaction detail with hash {} wasn't found in database", new Object[]{transactionHash});
                return;
            }
            TransactionReceipt transactionReceipt = (TransactionReceipt)event.getData();
            if (transactionReceipt == null) {
                transactionReceipt = this.getTransactionReceipt(transactionHash);
            }
            boolean broadcastSavingTransaction = transactionDetail.isPending();
            transactionDetail.setPending(false);
            transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
            if (transactionDetail.getTimestamp() == 0L) {
                if (blockTimestamp != null) {
                    transactionDetail.setTimestamp(blockTimestamp * 1000L);
                } else if (StringUtils.isNotBlank((CharSequence)blockHash)) {
                    EthBlock.Block block = this.getEthereumClientConnector().getBlock(blockHash);
                    transactionDetail.setTimestamp(block.getTimestamp().longValue() * 1000L);
                }
            }
            if (this.getTransactionDecoderService() == null) {
                LOG.debug((Object)"TransactionDecoderService is not yet injected in container, skip blockchain transaction processing");
                return;
            }
            this.getTransactionDecoderService().computeContractTransactionDetail(transactionDetail, (Object)transactionReceipt);
            if (WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) {
                this.getTransactionService().saveTransactionDetail(transactionDetail, broadcastSavingTransaction);
            } else {
                LOG.debug((Object)"Transaction with hash {} doesn't have a known wallet, it will be ignored");
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash) throws InterruptedException {
        TransactionReceipt transactionReceipt = this.getEthereumClientConnector().getTransactionReceipt(transactionHash);
        if (transactionReceipt == null || "0x0".equals(transactionReceipt.getStatus())) {
            return null;
        }
        return transactionReceipt;
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private BlockchainTransactionService getTransactionDecoderService() {
        if (this.transactionDecoder == null) {
            this.transactionDecoder = (BlockchainTransactionService)CommonsUtils.getService(BlockchainTransactionService.class);
        }
        return this.transactionDecoder;
    }
}

