/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.storage.WalletStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.picocontainer.Startable;
import org.web3j.abi.datatypes.Address;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.FastRawTransactionManager;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.tx.response.NoOpProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

public class EthereumWalletTokenAdminService
implements WalletTokenAdminService,
Startable,
ExoBlockchainTransactionService {
    private static final int ADMIN_WALLET_MIN_LEVEL = 2;
    private static final long DEFAULT_ADMIN_GAS = 300000L;
    private static final String NO_CONFIGURED_CONTRACT_ADDRESS = "No configured contract address";
    private static final String TRANSACTION_DETAIL_IS_MANDATORY = "Transaction detail is mandatory";
    private static final String TRANSACTION_HASH_IS_EMPTY = "Transaction hash is empty for transaction: ";
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletTokenAdminService.class);
    private static final String RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY = "receiver address parameter is mandatory";
    private ClassLoader webappClassLoader;
    private UserACL userACL;
    private WalletContractService walletContractService;
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletStorage accountStorage;
    private WalletTransactionService transactionService;
    private ERTTokenV2 ertInstance;
    private TransactionManager contractTransactionManager;
    private boolean isReadOnlyContract;

    public EthereumWalletTokenAdminService(EthereumClientConnector clientConnector, ClassLoader classLoader) {
        this.webappClassLoader = classLoader;
        this.clientConnector = clientConnector;
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    @ExoBlockchainTransaction
    public void start() {
        org.exoplatform.addon.wallet.model.Wallet wallet = this.getAdminWallet();
        if (wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            this.createAdminAccount();
            LOG.info((Object)"Admin wallet created");
        }
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        ContractDetail contractDetail = settings.getContractDetail();
        String contractAddress = settings.getContractAddress();
        if (contractDetail == null && StringUtils.isNotBlank((CharSequence)contractAddress)) {
            try {
                contractDetail = this.getContractDetailFromBlockchain(contractAddress);
            }
            catch (Exception e) {
                LOG.warn("Error retrieving contract with address {}", new Object[]{contractAddress, e});
            }
            if (contractDetail == null) {
                LOG.warn("Can't find contract with address {} in configured blockchain", new Object[]{contractAddress});
            } else {
                this.getContractService().saveContractDetail(contractDetail);
            }
        }
    }

    public void stop() {
    }

    @ExoBlockchainTransaction
    public void createAdminAccount() {
        try {
            this.createAdminAccount(null, this.getUserACL().getSuperUser());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("This exception shouldn't be thrown because no ACL check is made on server side method call", e);
        }
    }

    @ExoBlockchainTransaction
    public void createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        if (!org.exoplatform.addon.wallet.utils.WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " is not allowed to create admin wallet");
        }
        Identity identity = org.exoplatform.addon.wallet.utils.WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.ADMIN, (String)"admin");
        if (identity == null) {
            throw new IllegalStateException("Can't find identity of admin wallet");
        }
        long identityId = Long.parseLong(identity.getId());
        org.exoplatform.addon.wallet.model.Wallet wallet = this.getAccountService().getWalletByIdentityId(identityId);
        if (wallet != null && wallet.getAddress() != null && this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin") != null) {
            throw new IllegalStateException("Admin wallet has already an associated wallet, thus can't overwrite it");
        }
        ECKeyPair ecKeyPair = null;
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            try {
                ecKeyPair = Keys.createEcKeyPair();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating new wallet keys pair", e);
            }
        } else {
            if (!WalletUtils.isValidPrivateKey((String)privateKey)) {
                throw new IllegalStateException("Private key isn't valid");
            }
            ecKeyPair = Credentials.create((String)privateKey).getEcKeyPair();
        }
        WalletFile adminWallet = null;
        try {
            adminWallet = Wallet.createLight((String)this.accountService.getAdminAccountPassword(), (ECKeyPair)ecKeyPair);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Error creating new wallet", e);
        }
        wallet = new org.exoplatform.addon.wallet.model.Wallet();
        wallet.setEnabled(true);
        wallet.setId("admin");
        wallet.setType(WalletType.ADMIN.getId());
        wallet.setAddress("0x" + adminWallet.getAddress());
        wallet.setTechnicalId(identityId);
        this.getAccountService().saveWalletAddress(wallet, currentUser, false);
        try {
            String walletJson = org.exoplatform.addon.wallet.utils.WalletUtils.toJsonString((Object)adminWallet);
            this.getAccountStorage().saveWalletPrivateKey(identityId, walletJson);
            this.isReadOnlyContract = false;
        }
        catch (Exception e) {
            this.getAccountService().removeWalletByAddress(wallet.getAddress(), currentUser);
        }
    }

    public org.exoplatform.addon.wallet.model.Wallet getAdminWallet() {
        return this.getAccountService().getWalletByTypeAndId(WalletType.ADMIN.getId(), "admin");
    }

    public String getAdminWalletAddress() {
        org.exoplatform.addon.wallet.model.Wallet adminWallet = this.getAdminWallet();
        return adminWallet == null ? null : adminWallet.getAddress();
    }

    @ExoBlockchainTransaction
    public final boolean isApprovedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isApprovedAccount", new Object[]{address});
    }

    @ExoBlockchainTransaction
    public final int getAdminLevel(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        BigInteger adminLevel = (BigInteger)this.executeReadOperation(contractAddress, "getAdminLevel", new Object[]{address});
        return adminLevel == null ? 0 : adminLevel.intValue();
    }

    @ExoBlockchainTransaction
    public final boolean isAdminAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isAdmin", new Object[]{address, BigInteger.valueOf(1L)});
    }

    @ExoBlockchainTransaction
    public final boolean isInitializedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isInitializedAccount", new Object[]{address});
    }

    @ExoBlockchainTransaction
    public final BigInteger balanceOf(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        return (BigInteger)this.executeReadOperation(contractAddress, "balanceOf", new Object[]{address});
    }

    @ExoBlockchainTransaction
    public final BigInteger getEtherBalanceOf(String address) throws Exception {
        Web3j web3j = this.getClientConnector().getWeb3j();
        if (web3j == null) {
            throw new IllegalStateException("Can't get ether balance of " + address + " . Connection is not established.");
        }
        return ((EthGetBalance)web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    @ExoBlockchainTransaction
    public final TransactionDetail initialize(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiver = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiver)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (this.isInitializedAccount(receiver)) {
            throw new IllegalStateException("Wallet {} is already initialized");
        }
        String adminWalletAddress = this.getAdminWalletAddress();
        int decimals = this.getDecimals();
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(decimals);
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger balanceOfAdmin = this.balanceOf(adminWalletAddress);
        if (balanceOfAdmin == null || balanceOfAdmin.compareTo(tokenAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough tokens to initialize " + tokenAmount.longValue() + " tokens to " + receiver);
        }
        if (this.getEtherBalanceOf(adminWalletAddress).compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiver);
        }
        String contractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        String transactionHash = this.executeTokenTransaction(contractAddress, "initializeAccount", new Object[]{receiver, tokenAmount, etherAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException(TRANSACTION_HASH_IS_EMPTY + transactionDetail);
        }
        this.getAccountService().setInitializationStatus(receiver, WalletInitializationState.PENDING);
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setContractAddress(contractAddress);
        transactionDetail.setContractMethodName("initializeAccount");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    @ExoBlockchainTransaction
    public TransactionDetail sendEther(TransactionDetail transactionDetail, String currentUserId) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        if (transactionDetail.getValue() < 0.0) {
            throw new IllegalArgumentException("ether amount parameter has to be a positive amount");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, currentUserId);
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger adminEtherBalance = this.getEtherBalanceOf(adminWalletAddress);
        if (adminEtherBalance.compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        String transactionHash = this.executeSendEtherTransaction(transactionDetail.getTo(), transactionDetail.getValue());
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException(TRANSACTION_HASH_IS_EMPTY + transactionDetail);
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    @ExoBlockchainTransaction
    public final TransactionDetail sendToken(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        if (transactionDetail.getContractAmount() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        int decimals = this.getDecimals();
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(decimals);
        String contractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        String transactionHash = this.executeTokenTransaction(contractAddress, "transfer", new Object[]{receiverAddress, tokenAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException(TRANSACTION_HASH_IS_EMPTY + transactionDetail);
        }
        TransactionDetail persistedTransaction = this.getTransactionService().getTransactionByHash(transactionHash);
        if (persistedTransaction != null) {
            LOG.info("Transaction with hash {} already exists in database, it will be replaced with new data", new Object[]{transactionHash});
            transactionDetail.setId(persistedTransaction.getId());
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(contractAddress);
        transactionDetail.setContractMethodName("transfer");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    @ExoBlockchainTransaction
    public final TransactionDetail reward(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        if (transactionDetail.getContractAmount() < 0.0) {
            throw new IllegalArgumentException("reward amount parameter has to be a positive");
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be a positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        int decimals = this.getDecimals();
        BigInteger tokenAmount = transactionDetail.getValueDecimal(decimals);
        BigInteger rewardAmount = transactionDetail.getContractAmountDecimal(decimals);
        String contractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        String transactionHash = this.executeTokenTransaction(contractAddress, "reward", new Object[]{receiverAddress, tokenAmount, rewardAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException(TRANSACTION_HASH_IS_EMPTY + transactionDetail);
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(contractAddress);
        transactionDetail.setContractMethodName("reward");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    @ExoBlockchainTransaction
    public ContractDetail getContractDetailFromBlockchain(String contractAddress) {
        try {
            ContractDetail contractDetail = new ContractDetail();
            contractDetail.setAddress(contractAddress);
            contractDetail.setNetworkId(Long.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId()));
            BigInteger implementationVersion = (BigInteger)this.executeReadOperation(contractAddress, "version", new Object[0]);
            if (implementationVersion == null || implementationVersion.intValue() < 1) {
                return null;
            }
            contractDetail.setContractType(implementationVersion.toString());
            BigInteger decimals = (BigInteger)this.executeReadOperation(contractAddress, "decimals", new Object[0]);
            contractDetail.setDecimals(Integer.valueOf(decimals.intValue()));
            String name = (String)this.executeReadOperation(contractAddress, "name", new Object[0]);
            contractDetail.setName(name);
            String symbol = (String)this.executeReadOperation(contractAddress, "symbol", new Object[0]);
            contractDetail.setSymbol(symbol);
            String owner = (String)this.executeReadOperation(contractAddress, "owner", new Object[0]);
            contractDetail.setOwner(owner);
            BigInteger sellPrice = (BigInteger)this.executeReadOperation(contractAddress, "getSellPrice", new Object[0]);
            contractDetail.setSellPrice(String.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)sellPrice, (int)18)));
            return contractDetail;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while retrieving contract details from blockchain with address: " + contractAddress, e);
        }
    }

    private String checkContractAddress() {
        String contractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        return contractAddress;
    }

    private void setIssuer(TransactionDetail transactionDetail, String issuerUsername) {
        if (StringUtils.isNotBlank((CharSequence)issuerUsername)) {
            org.exoplatform.addon.wallet.model.Wallet issuerWallet = this.getAccountService().getWalletByTypeAndId(WalletType.USER.name(), issuerUsername);
            if (issuerWallet == null) {
                throw new IllegalStateException("Can't find identity of user with id " + issuerUsername);
            }
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private final void checkAdminWalletIsValid() throws Exception {
        String adminAddress = this.getAdminWalletAddress();
        if (adminAddress == null) {
            throw new IllegalStateException("No admin wallet is set");
        }
        int adminLevel = this.getAdminLevel(adminAddress);
        if (adminLevel < 2) {
            throw new IllegalStateException("Admin wallet haven't enough privileges to manage wallets");
        }
    }

    private String executeSendEtherTransaction(String receiverAddress, double amountInEther) throws Exception {
        BigInteger gasLimit;
        GlobalSettings settings;
        BigInteger gasPrice;
        String adminWalletAddress;
        BigInteger nonce;
        RawTransaction rawTransaction;
        byte[] signedMessage;
        String hexValue;
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null) {
            throw new IllegalStateException("Admin credentials are empty");
        }
        Web3j web3j = this.getClientConnector().getWeb3j();
        EthSendTransaction ethSendTransaction = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue = Numeric.toHexString((byte[])(signedMessage = TransactionEncoder.signMessage((RawTransaction)(rawTransaction = RawTransaction.createEtherTransaction((BigInteger)(nonce = this.getNonce(adminWalletAddress = this.getAdminWalletAddress())), (BigInteger)(gasPrice = BigInteger.valueOf((settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).getNetwork().getMinGasPrice())), (BigInteger)(gasLimit = BigInteger.valueOf(300000L)), (String)receiverAddress, (BigInteger)org.exoplatform.addon.wallet.utils.WalletUtils.convertToDecimals((double)amountInEther, (int)18))), (Credentials)adminCredentials)))).sendAsync().get();
        if (ethSendTransaction == null) {
            throw new IllegalStateException("Ether Transaction is null");
        }
        String transactionHash = ethSendTransaction.getTransactionHash();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Returned ether Transaction has empty hash");
        }
        return transactionHash;
    }

    private String executeTokenTransaction(String contractAddress, String methodName, Object ... arguments) throws Exception {
        ERTTokenV2 contractInstance = this.getContractInstance(contractAddress, true);
        Method methodToInvoke = this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        TransactionReceipt receipt = (TransactionReceipt)response.send();
        if (receipt == null) {
            throw new IllegalStateException("Transaction receipt is null");
        }
        return receipt.getTransactionHash();
    }

    private Object executeReadOperation(String contractAddress, String methodName, Object ... arguments) throws Exception {
        ERTTokenV2 contractInstance = this.getContractInstance(contractAddress, false);
        Method methodToInvoke = this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        return response.send();
    }

    private ERTTokenV2 getContractInstance(String contractAddress, boolean writeOperation) throws InterruptedException, IOException {
        if (writeOperation && this.contractTransactionManager instanceof FastRawTransactionManager) {
            FastRawTransactionManager fastRawTransactionManager = (FastRawTransactionManager)this.contractTransactionManager;
            BigInteger transactionCount = this.getNonce(fastRawTransactionManager.getFromAddress());
            fastRawTransactionManager.setNonce(transactionCount.subtract(BigInteger.valueOf(1L)));
        }
        if (this.ertInstance != null) {
            if (this.isReadOnlyContract && writeOperation) {
                throw new IllegalStateException("Admin account keys aren't set");
            }
            return this.ertInstance;
        }
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null && writeOperation) {
            throw new IllegalStateException("Admin account keys aren't set");
        }
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        BigInteger gasPrice = BigInteger.valueOf(settings.getNetwork().getMinGasPrice());
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        StaticGasProvider gasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.contractTransactionManager = this.getTransactionManager(adminCredentials);
        this.ertInstance = ERTTokenV2.load((String)contractAddress, (Web3j)this.getClientConnector().getWeb3j(), (TransactionManager)this.contractTransactionManager, (ContractGasProvider)gasProvider);
        this.isReadOnlyContract = adminCredentials == null;
        return this.ertInstance;
    }

    private BigInteger getNonce(String fromAddress) throws IOException, InterruptedException {
        return ((EthGetTransactionCount)this.getClientConnector().getWeb3j().ethGetTransactionCount(fromAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send()).getTransactionCount();
    }

    private TransactionManager getTransactionManager(Credentials credentials) throws InterruptedException {
        this.getClientConnector().waitConnection();
        Web3j web3j = this.getClientConnector().getWeb3j();
        if (credentials == null) {
            return new ReadonlyTransactionManager(web3j, Address.DEFAULT.toString());
        }
        return new FastRawTransactionManager(web3j, credentials, (TransactionReceiptProcessor)new NoOpProcessor(web3j));
    }

    private Credentials getAdminCredentials() {
        ECKeyPair adminWalletKeys = (ECKeyPair)this.getAdminWalletKeys();
        if (adminWalletKeys == null) {
            return null;
        }
        return Credentials.create((ECKeyPair)adminWalletKeys);
    }

    private Object getAdminWalletKeys() {
        String adminPrivateKey = this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)adminPrivateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(adminPrivateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.accountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private Method getMethod(String methodName) {
        Method[] methods;
        Method methodToInvoke = null;
        for (Method method : methods = ERTTokenV2.class.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            methodToInvoke = method;
        }
        return methodToInvoke;
    }

    private ContractDetail getPrincipalContractDetail() {
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        return settings.getContractDetail();
    }

    private int getDecimals() {
        return this.getPrincipalContractDetail().getDecimals();
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletStorage getAccountStorage() {
        if (this.accountStorage == null) {
            this.accountStorage = (WalletStorage)CommonsUtils.getService(WalletStorage.class);
        }
        return this.accountStorage;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.walletContractService == null) {
            this.walletContractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.walletContractService;
    }

    private EthereumClientConnector getClientConnector() {
        return this.clientConnector;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        }
        return this.userACL;
    }
}

