/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.json.JSONObject;

@Asynchronous
public class TransactionMinedListener
extends Listener<Object, JSONObject> {
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private WalletTransactionService transactionService;
    private ListenerService listenerService;

    public void onEvent(Event<Object, JSONObject> event) throws Exception {
        JSONObject transactionDetailObject = (JSONObject)event.getData();
        String hash = transactionDetailObject.getString("hash");
        TransactionDetail transactionDetails = this.getTransactionService().getTransactionByHash(hash);
        if (transactionDetails == null) {
            return;
        }
        HashSet<String> contractMethodsInvoked = new HashSet<String>();
        HashMap walletsModifications = new HashMap();
        String contractMethodName = transactionDetails.getContractMethodName();
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            contractMethodsInvoked.add(contractMethodName);
        }
        if (transactionDetails.isSucceeded()) {
            this.addWalletsModification(transactionDetails, walletsModifications);
        }
        if (!contractMethodsInvoked.isEmpty()) {
            this.getContractService().refreshContractDetail(contractMethodsInvoked);
        }
        if (!walletsModifications.isEmpty()) {
            this.getAccountService().refreshWalletsFromBlockchain(walletsModifications);
        }
        this.getListenerService().broadcast("exo.addon.wallet.transaction.modified", null, (Object)transactionDetails);
    }

    private void addWalletsModification(TransactionDetail transactionDetail, Map<String, Set<String>> walletsModifications) {
        if (transactionDetail == null) {
            return;
        }
        this.addWalletModificationState(transactionDetail.getFromWallet(), "ether_transfer", walletsModifications);
        String contractMethodName = transactionDetail.getContractMethodName();
        if (StringUtils.isBlank((CharSequence)contractMethodName)) {
            this.addWalletModificationState(transactionDetail.getToWallet(), "ether_transfer", walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transfer") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transferFrom")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getByWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"approve")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transferOwnership")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"initializeAccount") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"reward")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), "transfer", walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"addAdmin") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"removeAdmin") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"approveAccount") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"disapproveAccount") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transformToVested")) {
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
        }
    }

    private void addWalletModificationState(Wallet wallet, String contractMethodName, Map<String, Set<String>> walletsModifications) {
        if (wallet == null) {
            return;
        }
        String address = wallet.getAddress();
        if (!walletsModifications.containsKey(address)) {
            walletsModifications.put(address, new HashSet());
        }
        walletsModifications.get(address).add(contractMethodName);
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

