/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.storage.WalletStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.picocontainer.Startable;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.FastRawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumWalletTokenAdminService
implements WalletTokenAdminService,
Startable,
ExoWalletStatisticService {
    private static final Log LOG;
    private static final int ADMIN_WALLET_MIN_LEVEL = 2;
    private static final long DEFAULT_ADMIN_GAS = 300000L;
    private static final String NO_CONFIGURED_CONTRACT_ADDRESS = "No configured contract address";
    private static final String TRANSACTION_DETAIL_IS_MANDATORY = "Transaction detail is mandatory";
    private static final String TRANSACTION_HASH_IS_EMPTY = "Transaction hash is empty for transaction: ";
    private static final String RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY = "receiver address parameter is mandatory";
    private UserACL userACL;
    private WalletService walletService;
    private WalletContractService walletContractService;
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletStorage accountStorage;
    private WalletTransactionService transactionService;
    private ERTTokenV2 ertInstance;
    private TransactionManager contractTransactionManager;
    private boolean isReadOnlyContract;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private String configuredContractAddress;
    private Integer configuredContractDecimals;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public EthereumWalletTokenAdminService(EthereumClientConnector clientConnector) {
        this.clientConnector = clientConnector;
    }

    public void start() {
        try {
            this.configuredContractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getContractAddress();
            this.websocketURL = org.exoplatform.addon.wallet.utils.WalletUtils.getWebsocketURL();
            this.networkId = org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId();
            ContractDetail contractDetail = this.getContractService().getContractDetail(this.configuredContractAddress);
            if (contractDetail == null) {
                contractDetail = new ContractDetail();
                contractDetail.setAddress(this.configuredContractAddress);
                this.refreshContractDetailFromBlockchain(contractDetail, null);
                this.getWalletService().setConfiguredContractDetail(contractDetail);
            }
            this.configuredContractDecimals = this.getPrincipalContractDetail().getDecimals();
        }
        catch (Exception e) {
            LOG.warn("Error refreshing contract detail from blockchain with address {}", new Object[]{this.configuredContractAddress, e});
        }
        org.exoplatform.addon.wallet.model.Wallet wallet = this.getAdminWallet();
        if (wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            this.createAdminAccount();
            LOG.info((Object)"Admin wallet created");
        }
    }

    public void stop() {
    }

    public void createAdminAccount() {
        try {
            this.createAdminAccount(null, this.getUserACL().getSuperUser());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("This exception shouldn't be thrown because no ACL check is made on server side method call", e);
        }
    }

    public org.exoplatform.addon.wallet.model.Wallet createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        if (!org.exoplatform.addon.wallet.utils.WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " is not allowed to create admin wallet");
        }
        Identity identity = org.exoplatform.addon.wallet.utils.WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.ADMIN, (String)"admin");
        if (identity == null) {
            throw new IllegalStateException("Can't find identity of admin wallet");
        }
        long identityId = Long.parseLong(identity.getId());
        org.exoplatform.addon.wallet.model.Wallet wallet = this.getAccountService().getWalletByIdentityId(identityId);
        if (wallet != null && wallet.getAddress() != null && this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin") != null) {
            throw new IllegalStateException("Admin wallet has already an associated wallet, thus can't overwrite it");
        }
        ECKeyPair ecKeyPair = null;
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            try {
                ecKeyPair = Keys.createEcKeyPair();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating new wallet keys pair", e);
            }
        } else {
            if (!WalletUtils.isValidPrivateKey((String)privateKey)) {
                throw new IllegalStateException("Private key isn't valid");
            }
            ecKeyPair = Credentials.create((String)privateKey).getEcKeyPair();
        }
        WalletFile adminWallet = null;
        try {
            adminWallet = Wallet.createLight((String)this.accountService.getAdminAccountPassword(), (ECKeyPair)ecKeyPair);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Error creating new wallet", e);
        }
        wallet = new org.exoplatform.addon.wallet.model.Wallet();
        wallet.setEnabled(true);
        wallet.setId("admin");
        wallet.setType(WalletType.ADMIN.getId());
        wallet.setAddress("0x" + adminWallet.getAddress());
        wallet.setTechnicalId(identityId);
        this.getAccountService().saveWalletAddress(wallet, currentUser);
        try {
            String walletJson = org.exoplatform.addon.wallet.utils.WalletUtils.toJsonString((Object)adminWallet);
            this.getAccountStorage().saveWalletPrivateKey(identityId, walletJson);
            this.isReadOnlyContract = false;
        }
        catch (Exception e) {
            this.getAccountService().removeWalletByAddress(wallet.getAddress(), currentUser);
        }
        return wallet;
    }

    public org.exoplatform.addon.wallet.model.Wallet getAdminWallet() {
        return this.getAccountService().getWalletByTypeAndId(WalletType.ADMIN.getId(), "admin");
    }

    public String getAdminWalletAddress() {
        org.exoplatform.addon.wallet.model.Wallet adminWallet = this.getAdminWallet();
        return adminWallet == null ? null : adminWallet.getAddress();
    }

    public final boolean isApprovedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isApprovedAccount", new Object[]{address});
    }

    public final int getAdminLevel(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        BigInteger adminLevel = (BigInteger)this.executeReadOperation(contractAddress, "getAdminLevel", new Object[]{address});
        return adminLevel == null ? 0 : adminLevel.intValue();
    }

    public final boolean isInitializedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isInitializedAccount", new Object[]{address});
    }

    public final BigInteger balanceOf(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (BigInteger)this.executeReadOperation(contractAddress, "balanceOf", new Object[]{address});
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getBalance")
    public final BigInteger getEtherBalanceOf(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final TransactionDetail initialize(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiver = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiver)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (this.isInitializedAccount(receiver)) {
            throw new IllegalStateException("Wallet {} is already initialized");
        }
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger balanceOfAdmin = this.balanceOf(adminWalletAddress);
        if (balanceOfAdmin == null || balanceOfAdmin.compareTo(tokenAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough tokens to initialize " + tokenAmount.longValue() + " tokens to " + receiver);
        }
        if (this.getEtherBalanceOf(adminWalletAddress).compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiver);
        }
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = this.executeTokenTransaction(this.configuredContractAddress, "initializeAccount", new Object[]{receiver, tokenAmount, etherAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        this.getAccountService().setInitializationStatus(receiver, WalletInitializationState.PENDING);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("initializeAccount");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public TransactionDetail sendEther(TransactionDetail transactionDetail, String currentUserId) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getValue() < 0.0) {
            throw new IllegalArgumentException("ether amount parameter has to be a positive amount");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, currentUserId);
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger adminEtherBalance = this.getEtherBalanceOf(adminWalletAddress);
        if (adminEtherBalance.compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        String transactionHash = this.executeSendEtherTransaction(transactionDetail.getTo(), transactionDetail.getValue());
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public final TransactionDetail sendToken(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = this.executeTokenTransaction(this.configuredContractAddress, "transfer", new Object[]{receiverAddress, tokenAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        TransactionDetail persistedTransaction = this.getTransactionService().getTransactionByHash(transactionHash);
        if (persistedTransaction != null) {
            LOG.info("Transaction with hash {} already exists in database, it will be replaced with new data", new Object[]{transactionHash});
            transactionDetail.setId(persistedTransaction.getId());
        }
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("transfer");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public final TransactionDetail reward(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() < 0.0) {
            throw new IllegalArgumentException("reward amount parameter has to be a positive");
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be a positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        BigInteger tokenAmount = transactionDetail.getValueDecimal(this.configuredContractDecimals.intValue());
        BigInteger rewardAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = this.executeTokenTransaction(this.configuredContractAddress, "reward", new Object[]{receiverAddress, tokenAmount, rewardAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("reward");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public void retrieveWalletInformationFromBlockchain(org.exoplatform.addon.wallet.model.Wallet wallet, ContractDetail contractDetail, Set<String> walletModifications) throws Exception {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            LOG.debug("No wallet address: {}", new Object[]{wallet});
            return;
        }
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress()) || contractDetail.getDecimals() == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String walletAddress = wallet.getAddress();
        BigInteger walletEtherBalance = this.getEtherBalanceOf(walletAddress);
        wallet.setEtherBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletEtherBalance, (int)18)));
        if (wallet.getTokenBalance() == null || walletModifications == null || walletModifications.contains("reward") || walletModifications.contains("initializeAccount") || walletModifications.contains("transformToVested") || walletModifications.contains("transfer") || walletModifications.contains("transferFrom") || walletModifications.contains("approve")) {
            BigInteger walletTokenBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "balanceOf", new Object[]{walletAddress});
            wallet.setTokenBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletTokenBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getRewardBalance() == null || walletModifications == null || walletModifications.contains("reward")) {
            BigInteger walletRewardBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "rewardBalanceOf", new Object[]{walletAddress});
            wallet.setRewardBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletRewardBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getVestingBalance() == null || walletModifications == null || walletModifications.contains("transformToVested")) {
            BigInteger walletVestingBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "vestingBalanceOf", new Object[]{walletAddress});
            wallet.setVestingBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletVestingBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getAdminLevel() == null || walletModifications == null || walletModifications.contains("transferOwnership") || walletModifications.contains("removeAdmin") || walletModifications.contains("addAdmin")) {
            BigInteger walletAdminLevel = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "getAdminLevel", new Object[]{walletAddress});
            wallet.setAdminLevel(Integer.valueOf(walletAdminLevel.intValue()));
        }
        if (wallet.getIsApproved() == null || walletModifications == null || walletModifications.contains("initializeAccount") || walletModifications.contains("addAdmin") || walletModifications.contains("removeAdmin") || walletModifications.contains("approveAccount") || walletModifications.contains("disapproveAccount") || walletModifications.contains("transferOwnership")) {
            Boolean approved = (Boolean)this.executeReadOperation(this.configuredContractAddress, "isApprovedAccount", new Object[]{walletAddress});
            wallet.setIsApproved(approved);
        }
        if (wallet.getIsInitialized() == null || walletModifications == null || walletModifications.contains("initializeAccount")) {
            Boolean initialized = (Boolean)this.executeReadOperation(this.configuredContractAddress, "isInitializedAccount", new Object[]{walletAddress});
            wallet.setIsInitialized(initialized);
        }
    }

    public void refreshContractDetailFromBlockchain(ContractDetail contractDetail, Set<String> contractModifications) {
        if (contractDetail == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String contractAddress = contractDetail.getAddress();
        try {
            if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() <= 0L) {
                contractDetail.setNetworkId(Long.valueOf(this.networkId));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getContractType()) || StringUtils.equals((CharSequence)contractDetail.getContractType(), (CharSequence)"0") || contractModifications == null || contractModifications.contains("upgradeImplementation") || contractModifications.contains("upgradeData") || contractModifications.contains("upgradeDataAndImplementation")) {
                BigInteger implementationVersion = (BigInteger)this.executeReadOperation(contractAddress, "version", new Object[0]);
                if (implementationVersion == null || implementationVersion.intValue() < 1) {
                    return;
                }
                contractDetail.setContractType(implementationVersion.toString());
            }
            if (contractDetail.getDecimals() == null || contractDetail.getDecimals() <= 0) {
                BigInteger decimals = (BigInteger)this.executeReadOperation(contractAddress, "decimals", new Object[0]);
                contractDetail.setDecimals(Integer.valueOf(decimals.intValue()));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getName()) || contractModifications == null || contractModifications.contains("setName")) {
                String name = (String)this.executeReadOperation(contractAddress, "name", new Object[0]);
                contractDetail.setName(name);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSymbol()) || contractModifications == null || contractModifications.contains("setSymbol")) {
                String symbol = (String)this.executeReadOperation(contractAddress, "symbol", new Object[0]);
                contractDetail.setSymbol(symbol);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getOwner()) || contractModifications == null || contractModifications.contains("transferOwnership")) {
                String owner = (String)this.executeReadOperation(contractAddress, "owner", new Object[0]);
                contractDetail.setOwner(owner);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSellPrice()) || contractModifications == null || contractModifications.contains("setSellPrice")) {
                BigInteger sellPrice = (BigInteger)this.executeReadOperation(contractAddress, "getSellPrice", new Object[0]);
                contractDetail.setSellPrice(String.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)sellPrice, (int)18)));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getTotalSupply())) {
                BigInteger totalSupply = (BigInteger)this.executeReadOperation(contractAddress, "totalSupply", new Object[0]);
                contractDetail.setTotalSupply(String.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)totalSupply, (int)contractDetail.getDecimals())));
            }
            if (contractDetail.getIsPaused() == null || contractModifications == null || contractModifications.contains("pause") || contractModifications.contains("unPause")) {
                Boolean isPaused = (Boolean)this.executeReadOperation(contractAddress, "isPaused", new Object[0]);
                contractDetail.setIsPaused(isPaused);
            }
            if (contractDetail.getEtherBalance() == null || contractModifications == null || contractModifications.contains("depositFunds") || contractModifications.contains("transfer") || contractModifications.contains("transferFrom") || contractModifications.contains("approve")) {
                BigInteger contractEtherBalance = this.getEtherBalanceOf(contractAddress);
                contractDetail.setEtherBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)contractEtherBalance, (int)18)));
            }
            this.getContractService().saveContractDetail(contractDetail);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while retrieving contract details from blockchain with address: " + contractAddress, e);
        }
    }

    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        switch (operation) {
            case "eth_getBalance": {
                parameters.put("address", methodArgs[0]);
                break;
            }
            case "eth_call": {
                parameters.put("contract_address", methodArgs[0]);
                parameters.put("contract_method", methodArgs[1]);
                break;
            }
            case "SEND_ADMIN_ETHER_TRANSACTION": {
                this.addSendEtherTransactionParameters(parameters, methodArgs);
                break;
            }
            case "SEND_TOKEN_ADMIN_TRANSACTION": {
                String contractAddress = (String)methodArgs[0];
                String methodName = (String)methodArgs[1];
                org.exoplatform.addon.wallet.model.Wallet fromWallet = this.getAdminWallet();
                parameters.put("contract_address", contractAddress);
                parameters.put("contract_method", methodName);
                parameters.put("sender", fromWallet);
                if (StringUtils.equals((CharSequence)"initializeAccount", (CharSequence)methodName)) {
                    Object[] contractMethodParams = (Object[])methodArgs[2];
                    String toAddress = (String)contractMethodParams[0];
                    org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress(toAddress);
                    BigInteger tokenAmountDecimals = (BigInteger)contractMethodParams[1];
                    double tokenAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)tokenAmountDecimals, (int)this.configuredContractDecimals);
                    BigInteger etherAmountDecimals = (BigInteger)contractMethodParams[2];
                    double etherAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)etherAmountDecimals, (int)18);
                    parameters.put("receiver", toWallet);
                    parameters.put("amount_token", tokenAmount);
                    parameters.put("amount_ether", etherAmount);
                    break;
                }
                if (StringUtils.equals((CharSequence)"reward", (CharSequence)methodName) || StringUtils.equals((CharSequence)"transfer", (CharSequence)methodName)) {
                    Object[] contractMethodParams = (Object[])methodArgs[2];
                    String toAddress = (String)contractMethodParams[0];
                    org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress(toAddress);
                    BigInteger tokenAmountDecimals = (BigInteger)contractMethodParams[1];
                    double tokenAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)tokenAmountDecimals, (int)this.configuredContractDecimals);
                    parameters.put("receiver", toWallet);
                    parameters.put("amount_token", tokenAmount);
                    break;
                }
                LOG.warn("Admin wallet transaction with method name {} is not correctly managed in statistics", new Object[]{methodName});
                break;
            }
            default: {
                LOG.warn("Statistic type {} is not managed", new Object[]{operation});
                return null;
            }
        }
        if ("SEND_ADMIN_ETHER_TRANSACTION".equals(operation) || "SEND_TOKEN_ADMIN_TRANSACTION".equals(operation)) {
            parameters.put("operation", "eth_sendRawTransaction");
        }
        return parameters;
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="SEND_ADMIN_ETHER_TRANSACTION")
    public String executeSendEtherTransaction(String receiverAddress, double amountInEther) throws Exception {
        String string = receiverAddress;
        double d = amountInEther;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, string, Conversions.doubleObject((double)d), joinPoint};
        return (String)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="SEND_TOKEN_ADMIN_TRANSACTION")
    public String executeTokenTransaction(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray2);
        Object[] objectArray3 = new Object[]{this, string, string2, objectArray, joinPoint};
        return (String)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure5(objectArray3).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_call")
    public Object executeReadOperation(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray2);
        Object[] objectArray3 = new Object[]{this, string, string2, objectArray, joinPoint};
        return ExoWalletStatisticAspect.aspectOf().around(new AjcClosure7(objectArray3).linkClosureAndJoinPoint(69648));
    }

    private ERTTokenV2 getContractInstance(String contractAddress, boolean writeOperation) throws IOException {
        if (writeOperation && this.contractTransactionManager instanceof FastRawTransactionManager) {
            FastRawTransactionManager fastRawTransactionManager = (FastRawTransactionManager)this.contractTransactionManager;
            BigInteger transactionCount = this.getClientConnector().getNonce(fastRawTransactionManager.getFromAddress());
            fastRawTransactionManager.setNonce(transactionCount.subtract(BigInteger.valueOf(1L)));
        }
        if (this.ertInstance != null) {
            if (this.isReadOnlyContract && writeOperation) {
                throw new IllegalStateException("Admin account keys aren't set");
            }
            return this.ertInstance;
        }
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null && writeOperation) {
            throw new IllegalStateException("Admin account keys aren't set");
        }
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        BigInteger gasPrice = BigInteger.valueOf(this.getAdminGasPrice(settings));
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        StaticGasProvider gasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.contractTransactionManager = this.getClientConnector().getTransactionManager(adminCredentials);
        this.ertInstance = ERTTokenV2.load((String)contractAddress, (Web3j)this.getClientConnector().getWeb3j(), (TransactionManager)this.contractTransactionManager, (ContractGasProvider)gasProvider);
        this.isReadOnlyContract = adminCredentials == null;
        return this.ertInstance;
    }

    private String checkContractAddress() {
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        return this.configuredContractAddress;
    }

    private void setIssuer(TransactionDetail transactionDetail, String issuerUsername) {
        if (StringUtils.isNotBlank((CharSequence)issuerUsername)) {
            org.exoplatform.addon.wallet.model.Wallet issuerWallet = this.getAccountService().getWalletByTypeAndId(WalletType.USER.name(), issuerUsername);
            if (issuerWallet == null) {
                throw new IllegalStateException("Can't find identity of user with id " + issuerUsername);
            }
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private final void checkAdminWalletIsValid() throws Exception {
        String adminAddress = this.getAdminWalletAddress();
        if (adminAddress == null) {
            throw new IllegalStateException("No admin wallet is set");
        }
        int adminLevel = this.getAdminLevel(adminAddress);
        if (adminLevel < 2) {
            throw new IllegalStateException("Admin wallet haven't enough privileges to manage wallets");
        }
    }

    private Long getAdminGasPrice(GlobalSettings settings) {
        return settings.getNetwork().getMinGasPrice();
    }

    private Credentials getAdminCredentials() {
        ECKeyPair adminWalletKeys = (ECKeyPair)this.getAdminWalletKeys();
        if (adminWalletKeys == null) {
            return null;
        }
        return Credentials.create((ECKeyPair)adminWalletKeys);
    }

    private Object getAdminWalletKeys() {
        String adminPrivateKey = this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)adminPrivateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(adminPrivateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.accountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private void addSendEtherTransactionParameters(Map<String, Object> parameters, Object ... methodArgs) {
        org.exoplatform.addon.wallet.model.Wallet fromWallet = this.getAdminWallet();
        org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress((String)methodArgs[0]);
        double etherAmount = (Double)methodArgs[1];
        parameters.put("sender", fromWallet);
        parameters.put("receiver", toWallet);
        parameters.put("amount_ether", etherAmount);
    }

    private Method getMethod(String methodName) {
        Method[] methods;
        Method methodToInvoke = null;
        for (Method method : methods = ERTTokenV2.class.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            methodToInvoke = method;
        }
        return methodToInvoke;
    }

    private ContractDetail getPrincipalContractDetail() {
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        return settings.getContractDetail();
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletStorage getAccountStorage() {
        if (this.accountStorage == null) {
            this.accountStorage = (WalletStorage)CommonsUtils.getService(WalletStorage.class);
        }
        return this.accountStorage;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.walletContractService == null) {
            this.walletContractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.walletContractService;
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }

    private EthereumClientConnector getClientConnector() {
        return this.clientConnector;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        }
        return this.userACL;
    }

    static {
        EthereumWalletTokenAdminService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumWalletTokenAdminService.class);
    }

    static /* synthetic */ BigInteger getEtherBalanceOf_aroundBody0(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        Web3j web3j = ajc$this.getClientConnector().getWeb3j();
        if (web3j == null) {
            throw new IllegalStateException("Can't get ether balance of " + address + " . Connection is not established.");
        }
        return ((EthGetBalance)web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    static /* synthetic */ String executeSendEtherTransaction_aroundBody2(EthereumWalletTokenAdminService ajc$this, String receiverAddress, double amountInEther, JoinPoint joinPoint) {
        BigInteger gasLimit;
        GlobalSettings settings;
        BigInteger gasPrice;
        Credentials adminCredentials = ajc$this.getAdminCredentials();
        if (adminCredentials == null) {
            throw new IllegalStateException("Admin credentials are empty");
        }
        Web3j web3j = ajc$this.getClientConnector().getWeb3j();
        String adminWalletAddress = ajc$this.getAdminWalletAddress();
        BigInteger nonce = ajc$this.getClientConnector().getNonce(adminWalletAddress);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)(gasPrice = BigInteger.valueOf(ajc$this.getAdminGasPrice(settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()))), (BigInteger)(gasLimit = BigInteger.valueOf(300000L)), (String)receiverAddress, (BigInteger)org.exoplatform.addon.wallet.utils.WalletUtils.convertToDecimals((double)amountInEther, (int)18));
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)adminCredentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        if (ethSendTransaction == null) {
            throw new IllegalStateException("Ether Transaction is null");
        }
        String transactionHash = ethSendTransaction.getTransactionHash();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Returned ether Transaction has empty hash");
        }
        return transactionHash;
    }

    static /* synthetic */ String executeTokenTransaction_aroundBody4(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        ERTTokenV2 contractInstance = ajc$this.getContractInstance(contractAddress, true);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        TransactionReceipt receipt = (TransactionReceipt)response.send();
        if (receipt == null) {
            throw new IllegalStateException("Transaction receipt is null");
        }
        return receipt.getTransactionHash();
    }

    static /* synthetic */ Object executeReadOperation_aroundBody6(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        ERTTokenV2 contractInstance = ajc$this.getContractInstance(contractAddress, false);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        return response.send();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumWalletTokenAdminService.java", EthereumWalletTokenAdminService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getEtherBalanceOf", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "java.math.BigInteger"), 255);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeSendEtherTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:double", "receiverAddress:amountInEther", "java.lang.Exception", "java.lang.String"), 722);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeTokenTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.String"), 757);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeReadOperation", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.Object"), 775);
    }
}

