/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure1;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure3;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure5;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.abi.datatypes.Address;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;
import org.web3j.tx.FastRawTransactionManager;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.NoOpProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumClientConnector
implements ExoWalletStatisticService,
Startable {
    private static final Log LOG;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public EthereumClientConnector() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean blocking) {
        this.websocketURL = WalletUtils.getWebsocketURL();
        this.networkId = WalletUtils.getNetworkId();
        this.serviceStarted = true;
        this.connectionVerifierExecutor.scheduleAtFixedRate(() -> {
            try {
                if (this.isConnected()) {
                    return;
                }
                this.connect();
            }
            catch (Throwable e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint", e);
                }
                LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        if (blocking) {
            this.waitConnection();
        }
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.closeConnection();
    }

    public TransactionManager getTransactionManager(Credentials credentials) {
        if (credentials == null) {
            return new ReadonlyTransactionManager(this.getWeb3j(), Address.DEFAULT.toString());
        }
        return new FastRawTransactionManager(this.getWeb3j(), credentials, (TransactionReceiptProcessor)new NoOpProcessor(this.getWeb3j()));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionByHash")
    public Transaction getTransaction(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Transaction)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionReceipt")
    public TransactionReceipt getTransactionReceipt(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (TransactionReceipt)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_blockNumber")
    public long getLastestBlockNumber() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.longValue((Object)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getLogs")
    public Set<String> getContractTransactions(String contractsAddress, long fromBlock, long toBlock) throws IOException {
        String string = contractsAddress;
        long l = fromBlock;
        long l2 = toBlock;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        return (Set)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public Map<String, Object> getStatisticParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        switch (statisticType) {
            case "eth_getTransactionByHash": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionReceipt": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionCount": {
                parameters.put("wallet_address", methodArgs[0]);
                break;
            }
            case "eth_blockNumber": {
                parameters.put("last_block_number", result);
                break;
            }
            case "eth_getLogs": {
                parameters.put("from_block_number", methodArgs[1]);
                parameters.put("to_block_number", methodArgs[2]);
                if (result instanceof Set) {
                    parameters.put("transactions_count_received", ((Set)result).size());
                    break;
                }
                LOG.warn("Statistict type {} has an unexpected result class type", new Object[]{statisticType});
                break;
            }
            default: {
                LOG.warn("Statistic type {} not managed", new Object[]{statisticType});
                return null;
            }
        }
        return parameters;
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionCount")
    public BigInteger getNonce(String walletAddress) throws IOException {
        String string = walletAddress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Web3j getWeb3j() {
        this.waitConnection();
        return this.web3j;
    }

    private boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    private void waitConnection() {
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        try {
            while (!this.isConnected()) {
                if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
                    throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
                }
                if (this.serviceStopping) {
                    throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
                }
                LOG.debug((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An error is thrown while waiting for connection on blockchain", e);
        }
    }

    private boolean connect() throws Exception {
        if (this.connectionInProgress) {
            LOG.debug((Object)"Web3 connection is in progress");
            return false;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.websocketURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            return false;
        }
        if (!this.websocketURL.startsWith("ws:") && !this.websocketURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + this.websocketURL + " for Ethereum Websocket connection"));
            return false;
        }
        this.connectionInProgress = true;
        try {
            if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.websocketURL});
                boolean reconnected = this.webSocketClient.reconnectBlocking();
                if (reconnected) {
                    LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
                }
                boolean bl = reconnected;
                return bl;
            }
            LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            this.webSocketClient = new WebSocketClient(new URI(this.websocketURL));
            this.webSocketClient.setConnectionLostTimeout(10);
            this.web3jService = new WebSocketService(this.webSocketClient, true);
            this.webSocketClient.setListener((WebSocketListener)new /* Unavailable Anonymous Inner Class!! */);
            this.web3jService.connect();
            this.web3j = Web3j.build((Web3jService)this.web3jService);
            LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionInProgress = false;
        }
    }

    private void closeConnection() {
        if (this.web3j != null) {
            LOG.info((Object)"Closing blockchain connection");
            try {
                this.web3j.shutdown();
                this.web3j = null;
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e) {
                LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
            }
        }
        if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.web3jService.close();
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.webSocketClient.close();
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static {
        EthereumClientConnector.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    }

    static /* synthetic */ Transaction getTransaction_aroundBody0(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthTransaction ethTransaction;
        try {
            ethTransaction = (EthTransaction)ajc$this.getWeb3j().ethGetTransactionByHash(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransaction(transactionHash);
        }
        if (ethTransaction != null) {
            return (Transaction)ethTransaction.getResult();
        }
        return null;
    }

    static /* synthetic */ TransactionReceipt getTransactionReceipt_aroundBody2(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthGetTransactionReceipt ethGetTransactionReceipt;
        try {
            ethGetTransactionReceipt = (EthGetTransactionReceipt)ajc$this.getWeb3j().ethGetTransactionReceipt(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction receipt '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransactionReceipt(transactionHash);
        }
        if (ethGetTransactionReceipt != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    static /* synthetic */ long getLastestBlockNumber_aroundBody4(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        BigInteger blockNumber = ((EthBlockNumber)ajc$this.getWeb3j().ethBlockNumber().send()).getBlockNumber();
        return blockNumber.longValue();
    }

    static /* synthetic */ Set getContractTransactions_aroundBody6(EthereumClientConnector ajc$this, String contractsAddress, long fromBlock, long toBlock, JoinPoint joinPoint) {
        EthFilter filter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractsAddress);
        EthLog contractTransactions = (EthLog)ajc$this.getWeb3j().ethGetLogs(filter).send();
        List logs = (List)contractTransactions.getResult();
        HashSet<String> txHashes = new HashSet<String>();
        if (logs != null && !logs.isEmpty()) {
            for (EthLog.LogResult logResult : logs) {
                org.web3j.protocol.core.methods.response.Log contractEventLog = (org.web3j.protocol.core.methods.response.Log)logResult.get();
                txHashes.add(contractEventLog.getTransactionHash());
            }
        }
        return txHashes;
    }

    static /* synthetic */ BigInteger getNonce_aroundBody8(EthereumClientConnector ajc$this, String walletAddress, JoinPoint joinPoint) {
        return ((EthGetTransactionCount)ajc$this.getWeb3j().ethGetTransactionCount(walletAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send()).getTransactionCount();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumClientConnector.java", EthereumClientConnector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.Transaction"), 142);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionReceipt", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.TransactionReceipt"), 165);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastestBlockNumber", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "", "", "java.io.IOException", "long"), 184);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContractTransactions", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:long:long", "contractsAddress:fromBlock:toBlock", "java.io.IOException", "java.util.Set"), 203);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonce", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "walletAddress", "java.io.IOException", "java.math.BigInteger"), 274);
    }
}

