/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.contract.ERTTokenV2;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletInitializationState;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class EthereumBlockchainTransactionService
implements BlockchainTransactionService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumBlockchainTransactionService.class);
    private static final String TRANSFER_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFER_EVENT);
    private static final String APPROVAL_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVAL_EVENT);
    private static final String ADDED_ADMIN_METHOD_SIG = EventEncoder.encode((Event)ERTTokenV2.ADDEDADMIN_EVENT);
    private static final String REMOVED_ADMIN_SIG = EventEncoder.encode((Event)ERTTokenV2.REMOVEDADMIN_EVENT);
    private static final String APPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT);
    private static final String DISAPPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT);
    private static final String CONTRACT_PAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTPAUSED_EVENT);
    private static final String CONTRACT_UNPAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTUNPAUSED_EVENT);
    private static final String DEPOSIT_RECEIVED_SIG = EventEncoder.encode((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT);
    private static final String TOKEN_PRICE_CHANGED_SIG = EventEncoder.encode((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT);
    private static final String TRANSFER_OWNERSHIP_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT);
    private static final String ACCOUNT_INITIALIZATION_SIG = EventEncoder.encode((Event)ERTTokenV2.INITIALIZATION_EVENT);
    private static final String ACCOUNT_REWARD_SIG = EventEncoder.encode((Event)ERTTokenV2.REWARD_EVENT);
    private static final String ACCOUNT_VESTED_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTING_EVENT);
    private static final String TRANSFER_VESTING_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTINGTRANSFER_EVENT);
    private static final String UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADED_EVENT);
    private static final String DATA_UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADEDDATA_EVENT);
    private static final String NOSUFFICIENTFUND_EVENT_HASH = EventEncoder.encode((Event)ERTTokenV2.NOSUFFICIENTFUND_EVENT);
    private static final String TRANSACTIONFEE_EVENT_HASH = EventEncoder.encode((Event)ERTTokenV2.TRANSACTIONFEE_EVENT);
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG = new HashMap();
    private EthereumClientConnector ethereumClientConnector;
    private WalletAccountService accountService;
    private WalletTransactionService transactionService;
    private SettingService settingService;

    public EthereumBlockchainTransactionService(EthereumClientConnector ethereumClientConnector) {
        this.ethereumClientConnector = ethereumClientConnector;
    }

    public void start() {
        try {
            long lastWatchedBlockNumber = this.getLastWatchedBlockNumber();
            if (lastWatchedBlockNumber <= 0L) {
                lastWatchedBlockNumber = this.ethereumClientConnector.getLastestBlockNumber();
                this.saveLastWatchedBlockNumber(lastWatchedBlockNumber);
            }
            this.ethereumClientConnector.renewBlockSubscription(lastWatchedBlockNumber + 1L);
        }
        catch (Exception e) {
            LOG.error("Error while getting latest block number from blockchain with network id: {}", new Object[]{WalletUtils.getNetworkId(), e});
        }
    }

    public void stop() {
    }

    public void checkPendingTransactions(long pendingTransactionMaxDays) {
        List pendingTransactions = this.getTransactionService().getPendingTransactions();
        if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
            LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database", new Object[]{pendingTransactions.size()});
            for (TransactionDetail pendingTransactionDetail : pendingTransactions) {
                try {
                    this.checkTransactionStatusOnBlockchain(pendingTransactionDetail.getHash(), true);
                }
                catch (Exception e) {
                    LOG.warn("Error treating pending transaction: {}", new Object[]{pendingTransactionDetail, e});
                }
            }
        }
    }

    public void scanNewerBlocks() throws IOException {
        long lastWatchedBlockNumber;
        long lastEthereumBlockNumber = this.ethereumClientConnector.getLastestBlockNumber();
        if (lastEthereumBlockNumber <= (lastWatchedBlockNumber = this.getLastWatchedBlockNumber())) {
            LOG.debug("No new blocks to verify. last watched = {}. last blockchain block = {}", new Object[]{lastWatchedBlockNumber, lastEthereumBlockNumber});
            return;
        }
        String contractAddress = WalletUtils.getContractAddress();
        Set transactionHashes = this.ethereumClientConnector.getContractTransactions(contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber);
        LOG.debug("{} transactions has been found on contract {} between block {} and {}", new Object[]{transactionHashes.size(), contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
        boolean processed = true;
        for (String transactionHash : transactionHashes) {
            TransactionDetail transaction = this.getTransactionService().getTransactionByHash(transactionHash);
            if (transaction != null && transaction.isSucceeded()) continue;
            try {
                this.checkTransactionStatusOnBlockchain(transactionHash, false);
            }
            catch (Exception e) {
                LOG.warn("Error processing transaction with hash: {}", new Object[]{transactionHash, e});
                processed = false;
            }
        }
        if (processed) {
            this.saveLastWatchedBlockNumber(lastEthereumBlockNumber);
        }
    }

    public void sendRawTransactions() {
        List transactions = this.getTransactionService().getTransactionsToSend();
        HashSet<String> walletAddressesWithTransactionsSent = new HashSet<String>();
        for (TransactionDetail transactionDetail : transactions) {
            String from = transactionDetail.getFrom();
            if (transactionDetail.getSendingAttemptCount() > this.getTransactionService().getMaxAttemptsToSend()) {
                transactionDetail.setPending(false);
                transactionDetail.setSucceeded(false);
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
                continue;
            }
            if (walletAddressesWithTransactionsSent.contains(from) || !this.getTransactionService().canSendTransactionToBlockchain(from)) continue;
            walletAddressesWithTransactionsSent.add(from);
            try {
                this.ethereumClientConnector.sendTransactionToBlockchain(transactionDetail).whenComplete(this.handleTransactionSending(transactionDetail));
                transactionDetail.setSentTimestamp(System.currentTimeMillis());
            }
            catch (IOException e) {
                LOG.error("Error while sending transaction {} to blockchain", new Object[]{transactionDetail, e});
            }
            transactionDetail.setSendingAttemptCount(transactionDetail.getSendingAttemptCount() + 1L);
            this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        }
    }

    public void checkPendingTransactionValidity(TransactionDetail transactionDetail) {
        Duration duration;
        long creationTimestamp;
        if (transactionDetail == null || !transactionDetail.isPending()) {
            return;
        }
        long pendingTransactionMaxDays = this.getTransactionService().getPendingTransactionMaxDays();
        if (pendingTransactionMaxDays > 0L && (creationTimestamp = transactionDetail.getTimestamp()) > 0L && (duration = Duration.ofMillis(System.currentTimeMillis() - creationTimestamp)).toDays() >= pendingTransactionMaxDays) {
            String transactionHash = transactionDetail.getHash();
            Transaction transaction = this.ethereumClientConnector.getTransaction(transactionHash);
            if (transaction == null) {
                transactionDetail.setPending(false);
                transactionDetail.setSucceeded(false);
                transactionDetail.setNonce(0L);
                LOG.debug("Transaction '{}' was NOT FOUND on blockchain for more than '{}' days, so mark it as failed", new Object[]{transactionHash, pendingTransactionMaxDays});
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
            } else {
                LOG.debug("Transaction '{}' was FOUND on blockchain for more than '{}' days, so avoid marking it as failed", new Object[]{transactionHash, pendingTransactionMaxDays});
                this.checkTransactionStatusOnBlockchain(transactionHash, transaction, true);
            }
        }
    }

    public void checkTransactionStatusOnBlockchain(String transactionHash, boolean pendingTransactionFromDatabase) {
        Transaction transaction = this.ethereumClientConnector.getTransaction(transactionHash);
        this.checkTransactionStatusOnBlockchain(transactionHash, transaction, pendingTransactionFromDatabase);
    }

    public TransactionDetail refreshTransactionFromBlockchain(String hash) {
        TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(hash);
        if (transactionDetail == null) {
            return null;
        }
        this.checkTransactionStatusOnBlockchain(hash, true);
        return this.getTransactionService().getTransactionByHash(hash);
    }

    public long refreshBlockchainGasPrice() throws IOException {
        return this.ethereumClientConnector.getGasPrice().longValue();
    }

    private void checkTransactionStatusOnBlockchain(String transactionHash, Transaction transaction, boolean pendingTransactionFromDatabase) {
        boolean broadcastMinedTransaction;
        TransactionReceipt transactionReceipt;
        if (transaction == null) {
            if (pendingTransactionFromDatabase) {
                TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
                if (transactionDetail == null) {
                    throw new IllegalStateException("Transaction with hash " + transactionHash + " wasn't found in internal database while it should have been retrieved from it.");
                }
                LOG.debug("Transaction {} is marked as pending in database and is not yet found on blockchain", new Object[]{transactionHash});
                if (transactionDetail.getRawTransaction() == null) {
                    this.checkPendingTransactionValidity(transactionDetail);
                }
            } else {
                throw new IllegalStateException("Transaction with hash " + transactionHash + " is not marked as pending but the transaction wasn't found on blockchain");
            }
            return;
        }
        String blockHash = transaction.getBlockHash();
        if (StringUtils.isBlank((CharSequence)blockHash) || StringUtils.equalsIgnoreCase((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000000", (CharSequence)blockHash) || transaction.getBlockNumber() == null) {
            if (!pendingTransactionFromDatabase) {
                throw new IllegalStateException("Transaction " + transactionHash + " is marked as pending in blockchain while it's not marked as pending in database");
            }
            LOG.debug("Transaction {} is marked as pending in database and is always pending on blockchain", new Object[]{transactionHash});
            return;
        }
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        if (contractDetail == null) {
            throw new IllegalStateException("Principal contract detail wasn't found in database");
        }
        TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
        if (transactionDetail == null) {
            if (pendingTransactionFromDatabase) {
                throw new IllegalStateException("Transaction with hash " + transactionHash + " wasn't found in internal database while it should have been retrieved from it.");
            }
            String contractAddress = transaction.getTo();
            if (!StringUtils.equalsIgnoreCase((CharSequence)contractDetail.getAddress(), (CharSequence)contractAddress)) {
                LOG.debug("Transaction '{}' is not a contract transaction, thus it will not be added into database", new Object[]{transactionHash});
                return;
            }
            transactionDetail = new TransactionDetail();
            transactionDetail.setNetworkId(WalletUtils.getNetworkId());
            transactionDetail.setHash(transactionHash);
            transactionDetail.setPending(true);
        }
        if ((transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(transactionHash)) == null) {
            throw new IllegalStateException("Couldn't find transaction receipt with hash '" + transactionHash + "' on blockchain");
        }
        boolean bl = broadcastMinedTransaction = transactionDetail.isPending() || transactionDetail.isSucceeded() != transactionReceipt.isStatusOK();
        if (pendingTransactionFromDatabase && !transactionDetail.isPending()) {
            LOG.debug("Transaction '{}' seems to be already marked as not pending, skip processing it", new Object[]{transactionHash});
            return;
        }
        this.computeTransactionDetail(transactionDetail, contractDetail, transaction, transactionReceipt);
        if (pendingTransactionFromDatabase) {
            this.getTransactionService().saveTransactionDetail(transactionDetail, broadcastMinedTransaction);
        } else {
            if (StringUtils.isNotBlank((CharSequence)transactionDetail.getFrom()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getFromWallet())) {
                transactionDetail.setFromWallet(this.getAccountService().getWalletByAddress(transactionDetail.getFrom()));
            }
            if (StringUtils.isNotBlank((CharSequence)transactionDetail.getTo()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getToWallet())) {
                transactionDetail.setToWallet(this.getAccountService().getWalletByAddress(transactionDetail.getTo()));
            }
            if (StringUtils.isNotBlank((CharSequence)transactionDetail.getBy()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getByWallet())) {
                transactionDetail.setByWallet(this.getAccountService().getWalletByAddress(transactionDetail.getBy()));
            }
            if (WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) {
                this.getTransactionService().saveTransactionDetail(transactionDetail, broadcastMinedTransaction);
            } else if (this.getTransactionService().isLogAllTransaction()) {
                WalletUtils.logStatistics((TransactionDetail)transactionDetail);
            }
        }
    }

    private BiConsumer<? super EthSendTransaction, ? super Throwable> handleTransactionSending(TransactionDetail transactionDetail) {
        return (transaction, exception) -> {
            if (transaction != null && transaction.getTransactionHash() != null) {
                LOG.debug("Transaction {} has been confirmed with hash {}", new Object[]{transactionDetail.getHash(), transaction.getTransactionHash()});
                transactionDetail.setHash(transaction.getTransactionHash());
            }
            if (exception != null) {
                LOG.warn("Error when sending transaction {}.", new Object[]{transactionDetail, exception});
                Transaction transactionFromBlockchain = this.ethereumClientConnector.getTransaction(transaction.getTransactionHash());
                if (transactionFromBlockchain == null) {
                    transactionDetail.setSendingAttemptCount(transactionDetail.getSendingAttemptCount() + 1L);
                } else {
                    transactionDetail.setPending(false);
                    transactionDetail.setSucceeded(false);
                }
            }
            this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        };
    }

    public void computeTransactionDetail(TransactionDetail transactionDetail, ContractDetail contractDetail, Transaction transaction, TransactionReceipt transactionReceipt) {
        String receiverAddress;
        String contractAddress;
        boolean isContractTransaction;
        transactionDetail.setFrom(transaction.getFrom());
        transactionDetail.setSucceeded(transactionReceipt.isStatusOK());
        transactionDetail.setGasUsed(transactionReceipt.getGasUsed().intValue());
        transactionDetail.setGasPrice(transaction.getGasPrice().doubleValue());
        transactionDetail.setPending(false);
        transactionDetail.setNonce(transaction.getNonce().longValue());
        if (transactionDetail.getTimestamp() <= 0L) {
            transactionDetail.setTimestamp(System.currentTimeMillis());
        }
        if (transaction.getValue().compareTo(BigInteger.ZERO) >= 0) {
            BigInteger weiAmount = transaction.getValue();
            transactionDetail.setValueDecimal(weiAmount, 18);
        }
        if (!(isContractTransaction = StringUtils.equalsIgnoreCase((CharSequence)(contractAddress = contractDetail.getAddress()), (CharSequence)(receiverAddress = transaction.getTo())))) {
            transactionDetail.setTo(receiverAddress);
            transactionDetail.setTokenFee(0.0);
            transactionDetail.setEtherFee(0.0);
            transactionDetail.setContractAddress(null);
            transactionDetail.setContractMethodName(null);
            transactionDetail.setContractAmount(0.0);
            transactionDetail.setNoContractFunds(false);
            return;
        }
        transactionDetail.setContractAddress(contractAddress);
        if (!transactionReceipt.isStatusOK()) {
            if (StringUtils.equals((CharSequence)transactionDetail.getContractMethodName(), (CharSequence)"initializeAccount")) {
                this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
            }
            return;
        }
        String hash = transactionDetail.getHash();
        List logs = transactionReceipt.getLogs();
        if (logs != null && !logs.isEmpty()) {
            Integer contractDecimals = contractDetail.getDecimals();
            int logsSize = logs.size();
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logsSize});
            int i = 0;
            boolean transactionLogTreated = false;
            while (i < logsSize) {
                BigInteger amount;
                EventValues parameters;
                String methodName;
                org.web3j.protocol.core.methods.response.Log log;
                List topics;
                if ((topics = (log = (org.web3j.protocol.core.methods.response.Log)logs.get(i++)).getTopics()) == null || topics.isEmpty()) {
                    LOG.warn("Transaction {} has NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Treating transaction log {} with {} topics", new Object[]{hash, topics.size()});
                if (NOSUFFICIENTFUND_EVENT_HASH.equals(topic)) {
                    transactionDetail.setNoContractFunds(true);
                    continue;
                }
                if (TRANSACTIONFEE_EVENT_HASH.equals(topic)) {
                    EventValues parameters2 = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSACTIONFEE_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    BigInteger tokenFee = (BigInteger)((Type)parameters2.getNonIndexedValues().get(1)).getValue();
                    BigInteger etherFee = (BigInteger)((Type)parameters2.getNonIndexedValues().get(2)).getValue();
                    transactionDetail.setTokenFee(WalletUtils.convertFromDecimals((BigInteger)tokenFee, (int)contractDecimals));
                    transactionDetail.setEtherFee(WalletUtils.convertFromDecimals((BigInteger)etherFee, (int)18));
                    continue;
                }
                if (transactionLogTreated || StringUtils.isBlank((CharSequence)(methodName = (String)CONTRACT_METHODS_BY_SIG.get(topic)))) continue;
                transactionDetail.setContractMethodName(methodName);
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) {
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    if (!StringUtils.equals((CharSequence)transactionReceipt.getFrom(), (CharSequence)transactionDetail.getFrom())) {
                        transactionDetail.setBy(transactionReceipt.getFrom());
                        transactionDetail.setContractMethodName("transferFrom");
                    }
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approve")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.APPROVAL_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approveAccount")) {
                    if (logsSize > 1) continue;
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"disapproveAccount")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"addAdmin")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.ADDEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"removeAdmin")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.REMOVEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeData")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.UPGRADEDDATA_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeImplementation")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.UPGRADED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"depositFunds")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"setSellPrice")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transformToVested")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.VESTING_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transferOwnership")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"initializeAccount")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.INITIALIZATION_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(false);
                    if (transactionDetail.isSucceeded()) {
                        this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.INITIALIZED);
                        continue;
                    }
                    this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"reward")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.REWARD_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setValueDecimal(amount, contractDecimals.intValue());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (transactionLogTreated || i + 1 != logsSize) continue;
                LOG.warn("Can't find contract method name of transaction {}", new Object[]{transactionDetail});
            }
        }
    }

    private long getLastWatchedBlockNumber() {
        long networkId = WalletUtils.getNetworkId();
        SettingValue lastBlockNumberValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    private void saveLastWatchedBlockNumber(long lastWatchedBlockNumber) {
        long networkId = WalletUtils.getNetworkId();
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    static {
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(APPROVAL_SIG, "approve");
        CONTRACT_METHODS_BY_SIG.put(ADDED_ADMIN_METHOD_SIG, "addAdmin");
        CONTRACT_METHODS_BY_SIG.put(REMOVED_ADMIN_SIG, "removeAdmin");
        CONTRACT_METHODS_BY_SIG.put(APPROVED_ACCOUNT_SIG, "approveAccount");
        CONTRACT_METHODS_BY_SIG.put(DISAPPROVED_ACCOUNT_SIG, "disapproveAccount");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_PAUSED_SIG, "pause");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_UNPAUSED_SIG, "unPause");
        CONTRACT_METHODS_BY_SIG.put(DEPOSIT_RECEIVED_SIG, "depositFunds");
        CONTRACT_METHODS_BY_SIG.put(TOKEN_PRICE_CHANGED_SIG, "setSellPrice");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_OWNERSHIP_SIG, "transferOwnership");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_INITIALIZATION_SIG, "initializeAccount");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_REWARD_SIG, "reward");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_VESTED_SIG, "transformToVested");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_VESTING_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(UPGRADED_SIG, "upgradeImplementation");
        CONTRACT_METHODS_BY_SIG.put(DATA_UPGRADED_SIG, "upgradeData");
    }
}

