/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.cometd;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.cometd.annotation.Param;
import org.cometd.annotation.RemoteCall;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.UserCallListener;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdWebConferencingService
implements Startable {
    public static final String CALLS_CHANNEL_NAME = "/webconferencing/calls";
    public static final String CALLS_SERVICE_CHANNEL_NAME = "/service/webconferencing/calls";
    public static final String USERS_SERVICE_CHANNEL_NAME = "/service/webconferencing/users";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME = "/eXo/Application/WebConferencing/call";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME_ALL = "/eXo/Application/WebConferencing/call/**";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME_PARAMS = "/eXo/Application/WebConferencing/call/{callType}/{callInfo}";
    public static final String USER_SUBSCRIPTION_CHANNEL_NAME = "/eXo/Application/WebConferencing/user";
    public static final String USER_SUBSCRIPTION_CHANNEL_PATTERN = "/eXo/Application/WebConferencing/user/{userId}";
    public static final String COMMAND_GET = "get";
    public static final String COMMAND_CREATE = "create";
    public static final String COMMAND_UPDATE = "update";
    public static final String COMMAND_DELETE = "delete";
    public static final String COMMAND_GET_CALLS_STATE = "get_calls_state";
    private static final Log LOG = ExoLogger.getLogger(CometdWebConferencingService.class);
    protected final WebConferencingService webConferencing;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CallService service;
    protected final OrganizationService organization;
    protected final SessionProviderService sessionProviders;
    protected final IdentityRegistry identityRegistry;

    public CometdWebConferencingService(SessionProviderService sessionProviders, IdentityRegistry identityRegistry, OrganizationService organization, WebConferencingService webConferencing, EXoContinuationBayeux exoBayeux) {
        this.sessionProviders = sessionProviders;
        this.identityRegistry = identityRegistry;
        this.organization = organization;
        this.webConferencing = webConferencing;
        this.exoBayeux = exoBayeux;
        this.service = new CallService();
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdWebConferencingService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdWebConferencingService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdWebConferencingService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

            public void sessionRemoved(ServerSession session, boolean timedout) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdWebConferencingService.this.channelsAsString(session.getSubscriptions())));
                }
            }

            public void sessionAdded(ServerSession session, ServerMessage message) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdWebConferencingService.this.channelsAsString(session.getSubscriptions())));
                }
            }
        });
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    protected String currentUserId(ServerMessage message) {
        if (message != null) {
            return (String)message.get((Object)"exoId");
        }
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            return convo.getIdentity().getUserId();
        }
        return IdentityConstants.ANONIM;
    }

    protected String channelUserId(String channelId) throws IndexOutOfBoundsException {
        return channelId.substring(USER_SUBSCRIPTION_CHANNEL_NAME.length() + 1);
    }

    protected String channelsAsString(Set<ServerChannel> channles) {
        return channles.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    protected String callId(String type, String info) {
        return new StringBuffer(type).append('/').append(info).toString();
    }

    @Service(value="webconferencing")
    public class CallService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;
        private final Map<String, ChannelContext> channelContext = new ConcurrentHashMap<String, ChannelContext>();
        @Deprecated
        private final ServerSession.RemoveListener sessionRemoveListener = new SessionRemoveListener();
        private final ChannelSubscriptionListener subscriptionListener = new ChannelSubscriptionListener();
        private final UserChannelListener channelListener = new UserChannelListener();

        @PostConstruct
        public void postConstruct() {
            this.bayeux.addListener((BayeuxServer.BayeuxServerListener)this.channelListener);
            this.serverSession.addListener((ServerSession.ServerSessionListener)this.sessionRemoveListener);
        }

        @PreDestroy
        public void preDestroy() {
            this.bayeux.removeListener((BayeuxServer.BayeuxServerListener)this.channelListener);
            this.serverSession.removeListener((ServerSession.ServerSessionListener)this.sessionRemoveListener);
            for (ChannelContext context : this.channelContext.values()) {
                CometdWebConferencingService.this.webConferencing.removeUserCallListener(context.getListener());
            }
            this.channelContext.clear();
        }

        @Subscription(value={"/eXo/Application/WebConferencing/call/{callType}/{callInfo}"})
        public void subscribeCalls(Message message, @Param(value="callType") String callType, @Param(value="callInfo") String callInfo) {
            String callId = CometdWebConferencingService.this.callId(callType, callInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Call published in " + message.getChannel() + " by " + message.get((Object)"sender") + " callId: " + callId + " data: " + message.getJSON()));
            }
        }

        @Subscription(value={"/eXo/Application/WebConferencing/user"})
        public void subscribeUser(Message message, @Param(value="userId") String userId) {
            String channelId = message.getChannel();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User published in " + channelId + " by " + message.getClientId() + " userId: " + userId + " data: " + message.getJSON()));
            }
        }

        @RemoteCall(value={"/webconferencing/calls"})
        public void rcCalls(final RemoteCall.Caller caller, final Object data) {
            final ServerSession session = caller.getServerSession();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calls remote call by " + session.getId() + " data: " + data));
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block57: {
                        try {
                            Map arguments = (Map)data;
                            String currentUserId = (String)arguments.get("exoId");
                            if (currentUserId != null) {
                                String containerName = (String)arguments.get("exoContainerName");
                                if (containerName != null) {
                                    ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)containerName);
                                    if (exoContainer != null) {
                                        ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
                                        try {
                                            ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                                            IdentityRegistry identityRegistry = (IdentityRegistry)exoContainer.getComponentInstanceOfType(IdentityRegistry.class);
                                            SessionProviderService sessionProviders = (SessionProviderService)exoContainer.getComponentInstanceOfType(SessionProviderService.class);
                                            WebConferencingService webConferencing = (WebConferencingService)exoContainer.getComponentInstanceOfType(WebConferencingService.class);
                                            Identity userIdentity = identityRegistry.getIdentity(currentUserId);
                                            if (userIdentity != null) {
                                                ConversationState contextState = ConversationState.getCurrent();
                                                SessionProvider contextProvider = sessionProviders.getSessionProvider(null);
                                                try {
                                                    ConversationState convState = new ConversationState(userIdentity);
                                                    convState.setAttribute("subject", (Object)userIdentity.getSubject());
                                                    ConversationState.setCurrent((ConversationState)convState);
                                                    SessionProvider userProvider = new SessionProvider(convState);
                                                    sessionProviders.setSessionProvider(null, userProvider);
                                                    String id = (String)arguments.get("id");
                                                    if (id != null) {
                                                        String command = (String)arguments.get("command");
                                                        if (command != null) {
                                                            if (CometdWebConferencingService.COMMAND_GET.equals(command)) {
                                                                try {
                                                                    CallInfo call = webConferencing.getCall(id);
                                                                    if (call != null) {
                                                                        caller.result((Object)Utils.asJSON(call));
                                                                        break block57;
                                                                    }
                                                                    caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                                }
                                                                catch (Throwable e) {
                                                                    LOG.error((Object)("Error reading call info '" + id + "' by '" + currentUserId + "'"), e);
                                                                    caller.failure((Object)ErrorInfo.serverError("Error reading call record").asJSON());
                                                                }
                                                                break block57;
                                                            }
                                                            if (CometdWebConferencingService.COMMAND_UPDATE.equals(command)) {
                                                                String state = (String)arguments.get("state");
                                                                if (state != null) {
                                                                    try {
                                                                        CallInfo call;
                                                                        boolean stateRecognized = true;
                                                                        if ("started".equals(state)) {
                                                                            call = webConferencing.startCall(id);
                                                                        } else if ("stopped".equals(state)) {
                                                                            call = webConferencing.stopCall(id, false);
                                                                        } else if ("joined".equals(state)) {
                                                                            call = webConferencing.joinCall(id, currentUserId);
                                                                        } else if ("leaved".equals(state)) {
                                                                            call = webConferencing.leaveCall(id, currentUserId);
                                                                        } else {
                                                                            call = null;
                                                                            stateRecognized = false;
                                                                        }
                                                                        if (stateRecognized) {
                                                                            if (call != null) {
                                                                                caller.result((Object)Utils.asJSON(call));
                                                                            } else {
                                                                                caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                                            }
                                                                            break block57;
                                                                        }
                                                                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: state not recognized").asJSON());
                                                                    }
                                                                    catch (Throwable e) {
                                                                        LOG.error((Object)("Error updating call '" + id + "' by '" + currentUserId + "'"), e);
                                                                        caller.failure((Object)ErrorInfo.serverError("Error updating call record").asJSON());
                                                                    }
                                                                    break block57;
                                                                }
                                                                caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: state").asJSON());
                                                                break block57;
                                                            }
                                                            if (CometdWebConferencingService.COMMAND_CREATE.equals(command)) {
                                                                String ownerId = (String)arguments.get("owner");
                                                                if (ownerId != null) {
                                                                    String ownerType = (String)arguments.get("ownerType");
                                                                    if (ownerType != null) {
                                                                        String providerType = (String)arguments.get("provider");
                                                                        if (providerType != null) {
                                                                            String title = (String)arguments.get("title");
                                                                            if (title != null) {
                                                                                String pstr = (String)arguments.get("participants");
                                                                                if (pstr != null) {
                                                                                    List<String> participants = Arrays.asList(pstr.split(";"));
                                                                                    try {
                                                                                        CallInfo call = webConferencing.addCall(id, ownerId, ownerType, title, providerType, participants);
                                                                                        caller.result((Object)Utils.asJSON(call));
                                                                                    }
                                                                                    catch (CallInfoException e) {
                                                                                        caller.failure((Object)ErrorInfo.clientError(e.getMessage()).asJSON());
                                                                                    }
                                                                                    catch (Throwable e) {
                                                                                        LOG.error((Object)("Error creating call for '" + id + "' by '" + currentUserId + "'"), e);
                                                                                        caller.failure((Object)ErrorInfo.serverError("Error creating call record").asJSON());
                                                                                    }
                                                                                } else {
                                                                                    caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: participants").asJSON());
                                                                                }
                                                                            } else {
                                                                                caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: title").asJSON());
                                                                            }
                                                                        } else {
                                                                            caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: provider").asJSON());
                                                                        }
                                                                    } else {
                                                                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: ownerType").asJSON());
                                                                    }
                                                                } else {
                                                                    caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: owner").asJSON());
                                                                }
                                                                break block57;
                                                            }
                                                            if (CometdWebConferencingService.COMMAND_DELETE.equals(command)) {
                                                                try {
                                                                    CallInfo call = webConferencing.stopCall(id, true);
                                                                    if (call != null) {
                                                                        caller.result((Object)Utils.asJSON(call));
                                                                        break block57;
                                                                    }
                                                                    caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                                }
                                                                catch (Throwable e) {
                                                                    LOG.error((Object)("Error deleting call '" + id + "' by '" + currentUserId + "'"), e);
                                                                    caller.failure((Object)ErrorInfo.serverError("Error deleting call record").asJSON());
                                                                }
                                                                break block57;
                                                            }
                                                            if (CometdWebConferencingService.COMMAND_GET_CALLS_STATE.equals(command)) {
                                                                String userId = "me".equals(id) ? currentUserId : id;
                                                                if (userId.equals(currentUserId)) {
                                                                    try {
                                                                        CallState[] calls = webConferencing.getUserCalls(userId);
                                                                        caller.result((Object)Utils.asJSON(calls));
                                                                    }
                                                                    catch (Throwable e) {
                                                                        LOG.error((Object)("Error reading users calls for '" + id + "'"), e);
                                                                        caller.failure((Object)ErrorInfo.serverError("Error reading users calls").asJSON());
                                                                    }
                                                                } else {
                                                                    caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: id (does not match)").asJSON());
                                                                }
                                                            } else {
                                                                LOG.warn((Object)("Unknown call command " + command + " for '" + id + "' from '" + currentUserId + "'"));
                                                                caller.failure((Object)ErrorInfo.clientError("Unknown command").asJSON());
                                                            }
                                                            break block57;
                                                        }
                                                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: command").asJSON());
                                                        break block57;
                                                    }
                                                    caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: id").asJSON());
                                                    break block57;
                                                }
                                                finally {
                                                    ConversationState.setCurrent((ConversationState)contextState);
                                                    sessionProviders.setSessionProvider(null, contextProvider);
                                                }
                                            }
                                            LOG.warn((Object)("User identity not found " + currentUserId + " for remote call of " + CometdWebConferencingService.CALLS_CHANNEL_NAME));
                                            caller.failure((Object)ErrorInfo.clientError("User identity not found").asJSON());
                                            break block57;
                                        }
                                        finally {
                                            ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                                        }
                                    }
                                    LOG.warn((Object)("Container not found " + containerName + " for remote call of " + CometdWebConferencingService.CALLS_CHANNEL_NAME));
                                    caller.failure((Object)ErrorInfo.clientError("Container not found").asJSON());
                                    break block57;
                                }
                                caller.failure((Object)ErrorInfo.clientError("Container required").asJSON());
                                break block57;
                            }
                            caller.failure((Object)ErrorInfo.clientError("Unauthorized user").asJSON());
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error processing call request from client " + session.getId() + " with data: " + data), e);
                            caller.failure((Object)ErrorInfo.serverError("Error processing call request: " + e.getMessage()).asJSON());
                        }
                    }
                }
            }).start();
        }

        void cleanupChannelClient(String channelId, String clientId) {
            if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                ChannelContext context = this.channelContext.get(channelId);
                if (context != null) {
                    context.removeClient(clientId);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<<< User call channel context not found for client: " + clientId + ", channel:" + channelId));
                }
            }
        }

        class UserChannelListener
        implements BayeuxServer.ChannelListener {
            UserChannelListener() {
            }

            public void configureChannel(ConfigurableServerChannel channel) {
            }

            public void channelAdded(ServerChannel channel) {
                String channelId = channel.getId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("> Channel added: " + channelId));
                }
                if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                    channel.addListener((ConfigurableServerChannel.ServerChannelListener)CallService.this.subscriptionListener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Added subscription listener for channel: " + channelId));
                    }
                }
            }

            public void channelRemoved(String channelId) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("< Channel removed: " + channelId));
                }
                if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                    ChannelContext context = (ChannelContext)CallService.this.channelContext.remove(channelId);
                    if (context != null) {
                        CometdWebConferencingService.this.webConferencing.removeUserCallListener(context.getListener());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("<< Removed user call listener for channel: " + channelId));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<< User call channel context not found for:" + channelId));
                    }
                } else if (channelId.startsWith(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME) && channelId.length() > CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length()) {
                    String callId = channelId.substring(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length() + 1);
                    try {
                        CallInfo call = CometdWebConferencingService.this.webConferencing.getCall(callId);
                        if (call != null) {
                            CometdWebConferencingService.this.webConferencing.stopCall(callId, !call.getOwner().isGroup());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error reading call " + callId), (Throwable)e);
                    }
                }
            }
        }

        class ChannelSubscriptionListener
        implements ServerChannel.SubscriptionListener {
            ChannelSubscriptionListener() {
            }

            public void subscribed(ServerSession remote, ServerChannel channel, ServerMessage message) {
                block10: {
                    String clientId = remote.getId();
                    final String channelId = channel.getId();
                    String currentUserId = CometdWebConferencingService.this.currentUserId(message);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Subscribed: " + currentUserId + ", client:" + clientId + ", channel:" + channelId));
                    }
                    if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                        try {
                            if (currentUserId != null) {
                                String userId = CometdWebConferencingService.this.channelUserId(channelId);
                                if (currentUserId.equals(userId)) {
                                    ChannelContext context = CallService.this.channelContext.computeIfAbsent(channelId, k -> {
                                        UserCallListener listener = new UserCallListener(userId){

                                            @Override
                                            public void onPartLeaved(String callId, String providerType, String partId) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_leaved\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"part\": {");
                                                data.append("\"id\": \"");
                                                data.append(partId);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                            }

                                            @Override
                                            public void onPartJoined(String callId, String providerType, String partId) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_joined\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"part\": {");
                                                data.append("\"id\": \"");
                                                data.append(partId);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                            }

                                            @Override
                                            public void onCallState(String callId, String providerType, String callState, String callerId, String callerType) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_state\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"callState\": \"");
                                                data.append(callState);
                                                data.append("\",\"caller\": {");
                                                data.append("\"id\": \"");
                                                data.append(callerId);
                                                data.append("\",\"type\": \"");
                                                data.append(callerType);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)(">>>> Sent call state update to " + channelId + " by " + CometdWebConferencingService.this.currentUserId(null)));
                                                }
                                            }

                                            @Override
                                            public boolean isListening() {
                                                return true;
                                            }
                                        };
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("<<< Created user call context for " + userId + ", client:" + clientId + ", channel:" + channelId));
                                        }
                                        return new ChannelContext(listener);
                                    });
                                    context.addClient(clientId);
                                } else {
                                    LOG.warn((Object)("Subscribing to other user not possible, was user " + currentUserId + ", channel:" + channelId));
                                    remote.deliver((Session)CallService.this.serverSession, channelId, (Object)ErrorInfo.clientError("Subscribing to other user not possible").asJSON());
                                    if (!channel.unsubscribe(remote)) {
                                        LOG.warn((Object)("Unable to unsubscribe user " + currentUserId + " from channel " + channelId));
                                    }
                                }
                            } else {
                                LOG.warn((Object)("Subscribing by unauthorized user not possible, was channel: " + channelId));
                                remote.deliver((Session)CallService.this.serverSession, channelId, (Object)ErrorInfo.accessError("Unauthorized user").asJSON());
                                if (!channel.unsubscribe(remote)) {
                                    LOG.warn((Object)("Unable to unsubscribe unauthorized user from channel " + channelId));
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            if (!LOG.isDebugEnabled()) break block10;
                            LOG.debug((Object)(">> Ignore user channel w/o user ID at the end: " + channelId), (Throwable)e);
                        }
                    }
                }
            }

            public void unsubscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
                String clientId = session.getId();
                String channelId = channel.getId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<< Unsubscribed client:" + clientId + ", channel:" + channelId));
                }
                CallService.this.cleanupChannelClient(channelId, clientId);
            }
        }

        @Deprecated
        class SessionRemoveListener
        implements ServerSession.RemoveListener {
            SessionRemoveListener() {
            }

            public void removed(ServerSession session, boolean timeout) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Session removed: " + session.getId() + " timedout:" + timeout + " channels: " + CometdWebConferencingService.this.channelsAsString(session.getSubscriptions())));
                }
            }
        }

        class ChannelContext {
            final Set<String> clients = ConcurrentHashMap.newKeySet();
            final UserCallListener listener;

            ChannelContext(UserCallListener listener) {
                this.listener = listener;
            }

            UserCallListener getListener() {
                return this.listener;
            }

            boolean hasNoClients() {
                return this.clients.isEmpty();
            }

            boolean hasClient(String clientId) {
                return this.clients.contains(clientId);
            }

            boolean removeClient(String clientId) {
                boolean res = this.clients.remove(clientId);
                if (this.clients.size() == 0) {
                    CometdWebConferencingService.this.webConferencing.removeUserCallListener(this.listener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Removed user call listener for " + this.listener.getUserId() + ", client:" + clientId));
                    }
                } else if (res) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Removed user call client for " + this.listener.getUserId() + ", client:" + clientId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<<< User call client was not removed for " + this.listener.getUserId() + ", client:" + clientId));
                }
                return res;
            }

            boolean addClient(String clientId) {
                boolean wasEmpty = this.clients.size() == 0;
                boolean res = this.clients.add(clientId);
                if (wasEmpty && res) {
                    CometdWebConferencingService.this.webConferencing.addUserCallListener(this.listener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Added user call listener for " + this.listener.getUserId() + ", client:" + clientId));
                    }
                } else if (res) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Added user call client for " + this.listener.getUserId() + ", client:" + clientId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<<< User call client was not added for " + this.listener.getUserId() + ", client:" + clientId));
                }
                return res;
            }
        }
    }
}

