/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.rest;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.IdentityNotFound;
import org.exoplatform.webconferencing.InvalidCallStateException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;

@Path(value="/webconferencing")
@Produces(value={"application/json"})
public class RESTWebConferencingService
implements ResourceContainer {
    public static final String ME = "me";
    public static final String EMPTY = "".intern();
    protected static final Log LOG = ExoLogger.getLogger(RESTWebConferencingService.class);
    protected final WebConferencingService webConferencing;
    private final CacheControl cacheControl;

    public RESTWebConferencingService(WebConferencingService skype) {
        this.webConferencing = skype;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}")
    public Response getUserInfo(@Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                if (ME.equals(userName)) {
                    userName = currentUserName;
                }
                try {
                    UserInfo user = this.webConferencing.getUserInfo(userName);
                    if (user != null) {
                        return Response.ok().cacheControl(this.cacheControl).entity((Object)user).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("User not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading user info of '" + userName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading user " + userName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}/calls")
    public Response getUserCalls(@Context UriInfo uriInfo, @PathParam(value="name") String userName, @QueryParam(value="state") String callState) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                if (ME.equals(userName)) {
                    userName = currentUserName;
                }
                if (userName.equals(currentUserName)) {
                    if (callState != null && callState.length() == 0) {
                        callState = null;
                    }
                    try {
                        CallState[] calls = this.webConferencing.getUserCalls(userName);
                        if (calls != null) {
                            return Response.ok().cacheControl(this.cacheControl).entity((Object)calls).build();
                        }
                        return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading calls storage (null)")).build();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error reading user calls of '" + userName + "' by '" + currentUserName + "'"), e);
                        return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading user '" + userName + "' calls")).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name (does not match)")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}/call/{type}/{id}")
    public Response putUserCall(@Context UriInfo uriInfo, @PathParam(value="name") String userName, @PathParam(value="type") String type, @PathParam(value="id") String id, @FormParam(value="state") String state) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                if (ME.equals(userName)) {
                    userName = currentUserName;
                }
                if (userName.equals(currentUserName)) {
                    String callId = this.callId(type, id);
                    try {
                        if ("joined".equals(state)) {
                            CallInfo call = this.webConferencing.joinCall(callId, userName);
                            if (call != null) {
                                return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
                        }
                        if ("leaved".equals(state)) {
                            CallInfo call = this.webConferencing.leaveCall(callId, userName);
                            if (call != null) {
                                return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
                        }
                        return Response.ok().build();
                    }
                    catch (InvalidCallStateException e) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError(e.getMessage())).build();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error adding user call by '" + currentUserName + "'"), e);
                        return Response.serverError().entity((Object)ErrorInfo.serverError("Error adding user call for " + userName)).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name (does not match)")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/users")
    @Deprecated
    public Response getUsersInfo(@Context UriInfo uriInfo, @QueryParam(value="names") String names) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (names != null) {
                try {
                    LinkedHashSet<UserInfo> users = new LinkedHashSet<UserInfo>();
                    for (String userName : names.trim().split(";")) {
                        UserInfo user;
                        if (ME.equals(userName)) {
                            userName = currentUserName;
                        }
                        if ((user = this.webConferencing.getUserInfo(userName)) == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Skipped not found user: " + userName));
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("User " + userName + " not found or not accessible")).build();
                        }
                        users.add(user);
                    }
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)users.toArray()).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading users info of '" + names + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading users " + names)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: names")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space/{spaceName}")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="spaceName") String spaceName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                try {
                    WebConferencingService.SpaceInfo space = this.webConferencing.getSpaceInfo(spaceName);
                    if (space != null) {
                        if (space.getMembers().containsKey(currentUserName)) {
                            return Response.ok().cacheControl(this.cacheControl).entity((Object)space).build();
                        }
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not space member")).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading space info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/room/{name}/{id}")
    public Response getRoomInfo(@Context UriInfo uriInfo, @PathParam(value="name") String roomName, @PathParam(value="id") String roomId, @QueryParam(value="title") String roomTitle, @QueryParam(value="members") String roomMembers) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (roomId != null && roomId.length() > 0) {
                if (roomName != null && roomName.length() > 0) {
                    if (roomTitle == null || roomTitle.length() == 0) {
                        roomTitle = roomName.replace('_', ' ');
                    }
                    if (roomMembers != null && roomMembers.length() > 0) {
                        try {
                            WebConferencingService.RoomInfo room = this.webConferencing.getRoomInfo(roomId, roomName, roomTitle, roomMembers.trim().split(";"));
                            if (room != null) {
                                if (room.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)room).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Not room member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Room not found or not accessible")).build();
                        }
                        catch (IdentityNotFound e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Room member not found", (Throwable)e);
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError(e.getMessage())).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading room info of '" + roomName + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading room " + roomName)).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: members")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: id")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response getCallInfo(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallInfo call = this.webConferencing.getCall(callId);
                if (call != null) {
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading call info for '" + callId + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error reading call information")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response deleteCall(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallInfo call = this.webConferencing.stopCall(callId, true);
                if (call != null) {
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error removing call info for '" + callId + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error removing call information")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response putCall(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id, @FormParam(value="state") String state) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            String currentUserName = convo.getIdentity().getUserId();
            try {
                if ("stopped".equals(state)) {
                    CallInfo call = this.webConferencing.stopCall(callId, false);
                    if (call != null) {
                        return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
                }
                if ("started".equals(state)) {
                    CallInfo call = this.webConferencing.startCall(callId);
                    if (call != null) {
                        return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: state")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error updating call info for '" + callId + "' by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error updating the call")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response postCall(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id, @FormParam(value="title") String title, @FormParam(value="provider") String providerType, @FormParam(value="owner") String ownerId, @FormParam(value="ownerType") String ownerType, @FormParam(value="participants") String participants) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            if (title != null) {
                if (providerType != null) {
                    if (ownerId != null) {
                        if (ownerType != null) {
                            if (participants != null) {
                                String currentUserName = convo.getIdentity().getUserId();
                                try {
                                    CallInfo call = this.webConferencing.addCall(callId, ownerId, ownerType, title, providerType, Arrays.asList(participants.split(";")));
                                    return Response.ok().cacheControl(this.cacheControl).entity((Object)call).build();
                                }
                                catch (CallInfoException e) {
                                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError(e.getMessage())).build();
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)("Error creating call info for '" + callId + "' by '" + currentUserName + "'"), e);
                                    return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError("Error creating call record")).build();
                                }
                            }
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: participants")).build();
                        }
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: ownerType")).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: owner")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: provider")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControl).entity((Object)ErrorInfo.clientError("Wrong request parameters: title")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    private String callId(String type, String id) {
        return new StringBuffer(type).append('/').append(id).toString();
    }
}

