/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webconferencing.IdentityInfo;

public class UserInfo
extends IdentityInfo {
    public static final String TYPE_NAME = "user".intern();
    protected static final Log LOG = ExoLogger.getLogger(UserInfo.class);
    private final String firstName;
    private final String lastName;
    private final Map<String, List<IMInfo>> imAccounts = new HashMap<String, List<IMInfo>>();
    private String avatarUri;
    private String profileUri;
    private String state;

    public UserInfo(String userId, String firstName, String lastName) {
        super(userId, new StringBuffer(firstName).append(' ').append(lastName).toString());
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Map<String, Collection<IMInfo>> getImAccounts() {
        return Collections.unmodifiableMap(this.imAccounts);
    }

    public IMInfo addImAccount(String type, String id) {
        IMInfo im = new IMInfo(type, id);
        this.imAccounts.computeIfAbsent(type, list -> new ArrayList()).add(im);
        return im;
    }

    public void addImAccount(IMInfo ... ims) {
        for (IMInfo im : ims) {
            this.imAccounts.computeIfAbsent(im.getType(), list -> new ArrayList()).add(im);
        }
    }

    public boolean hasImAccount(String type) {
        return this.imAccounts.containsKey(type);
    }

    public Collection<IMInfo> getImAccount(String type) {
        return Collections.unmodifiableCollection((Collection)this.imAccounts.get(type));
    }

    public String getAvatarUri() {
        return this.avatarUri;
    }

    public void setAvatarUri(String avatarUri) {
        this.avatarUri = avatarUri;
    }

    public String getProfileUri() {
        return this.profileUri;
    }

    public void setProfileUri(String profileUri) {
        this.profileUri = profileUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class IMInfo {
        private final String type;
        private final String id;

        protected IMInfo(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

