/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.OriginInfo;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class CallInfo {
    protected static final Log LOG = ExoLogger.getLogger(CallInfo.class);
    protected final String id;
    protected final String title;
    protected final Set<UserInfo> participants = new LinkedHashSet<UserInfo>();
    protected final Set<OriginInfo> origins = new LinkedHashSet<OriginInfo>();
    protected final IdentityInfo owner;
    protected final String providerType;
    protected String state;
    protected Date lastDate;
    protected Date startDate;
    protected Date endDate;
    protected String inviteId;

    public CallInfo(String id, String title, IdentityInfo owner, String providerType) {
        this.id = id;
        this.title = title;
        this.owner = owner;
        this.providerType = providerType;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<UserInfo> getParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    public Set<OriginInfo> getOrigins() {
        return Collections.unmodifiableSet(this.origins);
    }

    public void addOrigins(Collection<OriginInfo> origins) {
        for (OriginInfo origin : origins) {
            this.addOrigin(origin);
        }
    }

    public void addOrigin(OriginInfo origin) {
        this.origins.add(origin);
    }

    public IdentityInfo getOwner() {
        return this.owner;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void addParticipants(Collection<UserInfo> parts) {
        for (UserInfo part : parts) {
            this.addParticipant(part);
        }
    }

    public void addParticipant(UserInfo part) {
        this.participants.add(part);
    }

    public void removeParticipants(Collection<UserInfo> parts) {
        for (UserInfo part : parts) {
            this.removeParticipant(part);
        }
    }

    public void removeParticipant(UserInfo part) {
        this.participants.remove(part);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(Date lastDate) {
        this.lastDate = lastDate;
    }

    public String getInviteId() {
        return this.inviteId;
    }

    public void setInviteId(String inviteId) {
        this.inviteId = inviteId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String toJSON() throws JsonException {
        return new JsonGeneratorImpl().createJsonObject((Object)new CallView()).toString();
    }

    public class CallView {
        public String getLastDate() {
            try {
                return Utils.formatISODate(CallInfo.this.getLastDate());
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to format call last date", (Throwable)e);
                return null;
            }
        }

        public String getStartDate() {
            try {
                return Utils.formatISODate(CallInfo.this.getStartDate());
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to format call start date", (Throwable)e);
                return null;
            }
        }

        public String getEndDate() {
            try {
                return Utils.formatISODate(CallInfo.this.getEndDate());
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to format call end date", (Throwable)e);
                return null;
            }
        }

        public String getId() {
            return CallInfo.this.getId();
        }

        public String getState() {
            return CallInfo.this.getState();
        }

        public String getInviteId() {
            return CallInfo.this.getInviteId();
        }

        public IdentityInfo getOwner() {
            return CallInfo.this.getOwner();
        }

        public String getProviderType() {
            return CallInfo.this.getProviderType();
        }

        public String getTitle() {
            return CallInfo.this.getTitle();
        }

        public Set<UserInfo> getParticipants() {
            return CallInfo.this.getParticipants();
        }

        public Set<OriginInfo> getOrigins() {
            return CallInfo.this.getOrigins();
        }
    }
}

