/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.webconferencing.dao.CallDAO$AjcClosure1;
import org.exoplatform.webconferencing.domain.CallEntity;

public class CallDAO
extends GenericDAOJPAImpl<CallEntity, String> {
    public static final int USER_CALL_DAYS_LIVETIME = 2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CallEntity findGroupCallByOwnerId(String ownerId) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerId", CallEntity.class).setParameter("ownerId", (Object)ownerId);
        try {
            return (CallEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public CallEntity findGroupCallByOwnerTypeId(String ownerId, String ownerType) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerTypeId", CallEntity.class).setParameter("ownerId", (Object)ownerId).setParameter("ownerType", (Object)ownerType);
        try {
            return (CallEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<CallEntity> findGroupCallsByOwnerTypeId(String ownerId, String ownerType) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerTypeId", CallEntity.class).setParameter("ownerId", (Object)ownerId).setParameter("ownerType", (Object)ownerType);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<CallEntity> findUserGroupCalls(String userId) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findUserGroupCalls", CallEntity.class).setParameter("userId", (Object)userId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public int deleteAllUsersCalls() throws PersistenceException, IllegalStateException, IllegalArgumentException {
        LocalDateTime expired = LocalDate.now().atStartOfDay().minusDays(2L);
        return this.getEntityManager().createNamedQuery("WebConfCall.deleteOwnerOlderCalls").setParameter("ownerType", (Object)"user").setParameter("expiredDate", (Object)Timestamp.valueOf(expired)).executeUpdate();
    }

    public List<CallEntity> findGroupCallsByState(String state) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallsByState", CallEntity.class).setParameter("state", (Object)state);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    @ExoTransactional
    public int updateStartedCallState(String state) {
        String string = state;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        CallDAO$AjcClosure1 callDAO$AjcClosure1 = new CallDAO$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(callDAO$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    static {
        CallDAO.ajc$preClinit();
    }

    static /* synthetic */ int updateStartedCallState_aroundBody0(CallDAO ajc$this, String state, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createQuery("UPDATE WebConfCall c SET c.state = :state  WHERE c.state = 'started'").setParameter("state", (Object)state);
        return query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CallDAO.java", CallDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateStartedCallState", "org.exoplatform.webconferencing.dao.CallDAO", "java.lang.String", "state", "", "int"), 186);
    }
}

