/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.notification.provider;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webconferencing.notification.utils.NotificationConstants;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CallRecordingPlugin", template="war:/notification/templates/mail/CallRecordingPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CallRecordingPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String language = this.getLanguage(notificationInfo);
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String recordingStatus = notificationInfo.getValueOwnerParameter(NotificationConstants.RECORDING_STATUS.getKey());
            String fileName = notificationInfo.getValueOwnerParameter(NotificationConstants.FILE_NAME.getKey());
            String fileUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.RECORDED_FILE_URL.getKey());
            String avatarUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.AVATAR_URL.getKey());
            String callOwner = notificationInfo.getValueOwnerParameter(NotificationConstants.CALL_OWNER.getKey());
            templateContext.put((Object)"RECORDING_STATUS", (Object)encoder.encode(recordingStatus));
            templateContext.put((Object)"FILE_URL", (Object)encoder.encode(fileUrl));
            templateContext.put((Object)"FILE_NAME", (Object)encoder.encode(fileName));
            templateContext.put((Object)"AVATAR_URL", (Object)encoder.encode(avatarUrl));
            templateContext.put((Object)"CALL_OWNER", (Object)encoder.encode(callOwner));
            String user = notificationInfo.getTo();
            templateContext.put((Object)"USER", (Object)encoder.encode(user));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
            templateContext.put((Object)"COMPANY_LINK", (Object)LinkProviderUtils.getBaseUrl());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

