/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.UserInfo;

public abstract class CallProvider
extends BaseComponentPlugin {
    public static final String CONFIG_PROVIDER_ACTIVE = "active";
    public static final String CONFIG_PROVIDER_DESCRIPTION = "description";
    public static final String CONFIG_PROVIDER_CONFIGURATION = "provider-configuration";
    protected static final String EMAIL_REGEX = "^(?=[A-Z0-9][A-Z0-9@._%+-]{5,253}+$)[A-Z0-9._%+-]{1,64}+@(?:(?=[A-Z0-9-]{1,63}+\\.)[A-Z0-9]++(?:-[A-Z0-9]++)*+\\.){1,8}+[A-Z]{2,63}+$";
    protected final Pattern emailTest = Pattern.compile("^(?=[A-Z0-9][A-Z0-9@._%+-]{5,253}+$)[A-Z0-9._%+-]{1,64}+@(?:(?=[A-Z0-9-]{1,63}+\\.)[A-Z0-9]++(?:-[A-Z0-9]++)*+\\.){1,8}+[A-Z]{2,63}+$", 34);
    protected final Map<String, String> config;
    protected boolean active;

    public CallProvider(InitParams params) throws ConfigurationException {
        PropertiesParam param = params.getPropertiesParam(CONFIG_PROVIDER_CONFIGURATION);
        if (param == null) {
            throw new ConfigurationException("Property parameters provider-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        this.active = Boolean.valueOf(this.config.getOrDefault(CONFIG_PROVIDER_ACTIVE, Boolean.TRUE.toString()));
    }

    public int hashCode() {
        String type = this.getType();
        if (type != null && type.length() > 0) {
            int hc = 7 + type.hashCode();
            String version = this.getVersion();
            if (version != null) {
                hc = hc * 31 + version.hashCode();
            }
            return hc;
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && CallProvider.class.isAssignableFrom(obj.getClass())) {
            return ((CallProvider)((Object)CallProvider.class.cast(obj))).getType().equals(this.getType());
        }
        return false;
    }

    public final boolean isActive() {
        return this.active;
    }

    final void setActive(boolean active) {
        this.active = active;
    }

    public boolean isSupportedType(String type) {
        return this.getType().equals(type);
    }

    public abstract String getTitle();

    public String getDetails() {
        return this.getDescription();
    }

    public abstract String getVersion();

    public abstract String getType();

    public abstract String[] getSupportedTypes();

    public abstract UserInfo.IMInfo getIMInfo(String var1) throws CallProviderException;

    public abstract class Settings {
        private final Map<String, String> messages = new HashMap<String, String>();

        public final boolean isActive() {
            return CallProvider.this.isActive();
        }

        public String getType() {
            return CallProvider.this.getType();
        }

        public String[] getSupportedTypes() {
            return CallProvider.this.getSupportedTypes();
        }

        public String getTitle() {
            return CallProvider.this.getTitle();
        }

        public String getVersion() {
            return CallProvider.this.getVersion();
        }

        public Map<String, String> getMessages() {
            return this.messages;
        }

        public void addMessages(Map<String, String> messages) {
            this.messages.putAll(messages);
        }
    }
}

