/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.UserInfo;

public class CallInfo {
    protected final String id;
    protected final String title;
    protected final Set<String> participantIds = new LinkedHashSet<String>();
    protected final Set<UserInfo> participants = new LinkedHashSet<UserInfo>();
    protected final IdentityInfo owner;
    protected final String ownerType;
    protected final String ownerLink;
    protected final String avatarLink;
    protected final String providerType;
    protected String state;

    public CallInfo(String id, String title, IdentityInfo owner, String ownerType, String ownerLink, String avatarLink, String providerType) {
        this.id = id;
        this.title = title;
        this.owner = owner;
        this.ownerType = ownerType;
        this.ownerLink = ownerLink;
        this.avatarLink = avatarLink;
        this.providerType = providerType;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<UserInfo> getParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    public boolean isParticipant(String partId) {
        return this.participantIds.contains(partId);
    }

    public IdentityInfo getOwner() {
        return this.owner;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getOwnerLink() {
        return this.ownerLink;
    }

    public String getAvatarLink() {
        return this.avatarLink;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void addParticipants(Collection<UserInfo> parts) {
        for (UserInfo part : parts) {
            this.addParticipant(part);
        }
    }

    public void addParticipant(UserInfo part) {
        this.participants.add(part);
        this.participantIds.add(part.getId());
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }
}

