/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.UserInfo;

public class CallInfo {
    protected final String id;
    protected final String title;
    protected final Set<UserInfo> participants = new LinkedHashSet<UserInfo>();
    protected final IdentityInfo owner;
    protected final String providerType;
    protected String state;
    protected Date lastDate;

    public CallInfo(String id, String title, IdentityInfo owner, String providerType) {
        this.id = id;
        this.title = title;
        this.owner = owner;
        this.providerType = providerType;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<UserInfo> getParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    public IdentityInfo getOwner() {
        return this.owner;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void addParticipants(Collection<UserInfo> parts) {
        for (UserInfo part : parts) {
            this.addParticipant(part);
        }
    }

    public void addParticipant(UserInfo part) {
        this.participants.add(part);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(Date lastDate) {
        this.lastDate = lastDate;
    }
}

