/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.notification.utils.NotificationConstants;

public class CallRecordingNotificationListener
extends Listener<CallInfo, Map<? extends String, ? extends String>> {
    private final IdentityManager identityManager;
    private final WebConferencingService webConferencingService;
    private final SpaceService spaceService;

    public CallRecordingNotificationListener(IdentityManager identityManager, WebConferencingService webConferencingService, SpaceService spaceService) {
        this.identityManager = identityManager;
        this.webConferencingService = webConferencingService;
        this.spaceService = spaceService;
    }

    public void onEvent(Event<CallInfo, Map<? extends String, ? extends String>> event) throws Exception {
        CallInfo callInfo = (CallInfo)event.getSource();
        Map info = (Map)event.getData();
        List participants = callInfo.getParticipants().stream().map(IdentityInfo::getId).collect(Collectors.toList());
        String status = (String)info.get("status");
        String fileName = info.get("file_name") == null ? "" : (String)info.get("file_name");
        String identity = info.get("identity") == null ? null : (String)info.get("identity");
        String callType = info.get("type") == null ? "" : (String)info.get("type");
        String name = "";
        Object avatarUrl = CommonsUtils.getCurrentDomain();
        if (callType.equals("space") || callType.equals("space_event")) {
            Space space;
            if (callType.equals("space_event")) {
                Identity spaceIdentity = this.identityManager.getIdentity(identity);
                space = this.spaceService.getSpaceByPrettyName(spaceIdentity.getRemoteId());
            } else {
                space = this.spaceService.getSpaceByPrettyName(identity);
            }
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            String fileUrl = this.webConferencingService.getRecordingUrl(identity, fileName, callType);
            fileUrl = fileUrl.replace(CommonsUtils.getCurrentDomain(), "");
            ctx.append(NotificationConstants.RECORDED_FILE_URL, (Object)fileUrl);
            ctx.append(NotificationConstants.CALL_PARTICIPANTS, participants);
            ctx.append(NotificationConstants.FILE_NAME, (Object)fileName);
            ctx.append(NotificationConstants.AVATAR_URL, (Object)space.getAvatarUrl());
            ctx.append(NotificationConstants.RECORDING_STATUS, (Object)status);
            ctx.append(NotificationConstants.CALL_TYPE, (Object)callType);
            ctx.append(NotificationConstants.CALL_OWNER, (Object)space.getDisplayName());
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CallRecordingPlugin"))).execute(ctx);
        } else {
            if (callType.equals("user")) {
                Identity ident = this.identityManager.getOrCreateIdentity("organization", identity);
                if (ident != null) {
                    name = ident.getProfile().getFullName();
                    avatarUrl = (String)avatarUrl + ident.getProfile().getAvatarUrl();
                }
            } else {
                name = callInfo.getTitle();
                avatarUrl = (String)avatarUrl + "/chat/img/room-default.jpg";
            }
            for (String participant : participants) {
                NotificationContext ctx = NotificationContextImpl.cloneInstance();
                ArrayList<String> part = new ArrayList<String>();
                part.add(participant);
                String fileUrl = this.webConferencingService.getRecordingUrl(participant, fileName, callType);
                fileUrl = fileUrl.replace(CommonsUtils.getCurrentDomain(), "");
                ctx.append(NotificationConstants.FILE_NAME, (Object)fileName);
                ctx.append(NotificationConstants.RECORDING_STATUS, (Object)status);
                ctx.append(NotificationConstants.RECORDED_FILE_URL, (Object)fileUrl);
                ctx.append(NotificationConstants.CALL_PARTICIPANTS, part);
                ctx.append(NotificationConstants.AVATAR_URL, avatarUrl);
                ctx.append(NotificationConstants.CALL_TYPE, (Object)callType);
                ctx.append(NotificationConstants.CALL_OWNER, (Object)name);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CallRecordingPlugin"))).execute(ctx);
            }
        }
    }
}

