/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.portlet;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webui.application.WebuiRequestContext;

public class WebConferencingPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(WebConferencingPortlet.class);
    private WebConferencingService webConferencing;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String remoteUser = request.getRemoteUser();
        try {
            ContextInfo context = Utils.getCurrentContext((String)remoteUser, (Locale)request.getLocale());
            String contextJson = Utils.asJSON((Object)context);
            UserInfo exoUser = this.webConferencing.getUserInfo(remoteUser);
            if (exoUser != null) {
                String exoUserJson = Utils.asJSON((Object)exoUser);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/webConferencingPortlet", "webConferencingPortlet").addScripts("webConferencingPortlet.start(" + exoUserJson + "," + contextJson + ");");
            } else {
                LOG.warn((Object)("Web Conferencing portlet cannot be initialized: user info cannot be obtained for " + remoteUser));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error processing Web Conferencing portlet for user " + remoteUser), (Throwable)e);
        }
    }
}

