/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc;

import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.webrtc.WebrtcSettings;

public class WebrtcProvider
extends CallProvider {
    public static final String WEBRTC_TYPE = "webrtc";
    public static final String WEBRTC_TITLE = "WebRTC";
    public static final String VERSION = "1.0.0";

    public WebrtcProvider(InitParams params) throws ConfigurationException {
        super(params);
    }

    public SettingsBuilder settings() {
        return new SettingsBuilder();
    }

    public UserInfo.IMInfo getIMInfo(String imId) throws CallProviderException {
        return new WebrtcIMInfo(imId);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getType() {
        return WEBRTC_TYPE;
    }

    public String[] getSupportedTypes() {
        return new String[]{this.getType()};
    }

    public String getTitle() {
        return WEBRTC_TITLE;
    }

    public class WebrtcIMInfo
    extends UserInfo.IMInfo {
        protected WebrtcIMInfo(String id) {
            this(WebrtcProvider.WEBRTC_TYPE, id);
        }

        protected WebrtcIMInfo(String type, String id) {
            super(type, id);
        }
    }

    public class SettingsBuilder {
        protected String callUri;

        public SettingsBuilder callUri(String callUri) {
            this.callUri = callUri;
            return this;
        }

        public WebrtcSettings build() {
            return new WebrtcSettings(WebrtcProvider.this.getType(), WebrtcProvider.this.getSupportedTypes(), WebrtcProvider.this.getTitle(), "Call", "Join", WebrtcProvider.this.getVersion(), this.callUri);
        }
    }
}

