/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.webrtc.WebrtcProvider;
import org.exoplatform.webconferencing.webrtc.server.WebrtcContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class WebrtcCallServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -6075521943684342591L;
    protected static final Logger LOG = LoggerFactory.getLogger(WebrtcCallServlet.class);
    private static final String UNAUTHORIZED_PAGE = "/WEB-INF/pages/unauthorized.html";
    private static final String SERVER_ERROR_PAGE = "/WEB-INF/pages/servererror.html";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            HttpServletRequest httpReq = req;
            HttpServletResponse httpRes = resp;
            Object redirectUri = httpReq.getAttribute(WebrtcContext.CALL_REDIRECT);
            if (redirectUri != null) {
                String ruri = (String)redirectUri;
                if (ruri.length() > 0) {
                    httpRes.sendRedirect(ruri);
                }
            } else {
                httpRes.setContentType("text/html; charset=UTF-8");
                String remoteUser = httpReq.getRemoteUser();
                ExoContainer container = this.getContainer();
                WebConferencingService webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
                if (webConferencing != null) {
                    WebrtcProvider provider;
                    try {
                        provider = (WebrtcProvider)webConferencing.getProvider("webrtc");
                    }
                    catch (ClassCastException e) {
                        LOG.error((Object)("Provider webrtc isn't an instance of " + WebrtcProvider.class.getName()), (Throwable)e);
                        provider = null;
                    }
                    if (provider != null) {
                        try {
                            req.setCharacterEncoding("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            LOG.error((Object)"Encoding not supported", (Throwable)e);
                        }
                        if (remoteUser != null) {
                            try {
                                ContextInfo context = Utils.getCurrentContext((String)remoteUser, (Locale)req.getLocale());
                                httpReq.setAttribute("contextInfo", (Object)Utils.asJSON((Object)context));
                                UserInfo exoUser = webConferencing.getUserInfo(remoteUser);
                                if (exoUser != null) {
                                    httpReq.setAttribute("userInfo", (Object)Utils.asJSON((Object)exoUser));
                                    URI callURI = new URI(httpReq.getScheme(), null, httpReq.getServerName(), httpReq.getServerPort(), "/webrtc/call", null, null);
                                    WebrtcProvider.WebrtcSettings settings = provider.settings().callUri(callURI.toString()).locale(httpReq.getLocale()).build();
                                    httpReq.setAttribute("settings", (Object)Utils.asJSON((Object)settings));
                                    httpReq.getRequestDispatcher("/WEB-INF/pages/call_part1.jsp").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    ServletContext cometdContext = httpReq.getSession().getServletContext().getContext("/cometd");
                                    cometdContext.getRequestDispatcher("/javascript/eXo/commons/commons-cometd3.js").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    httpReq.getRequestDispatcher("/WEB-INF/pages/call_part2.jsp").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    break block16;
                                }
                                LOG.warn((Object)("WebRTC servlet cannot be initialized: user info cannot be obtained for " + remoteUser));
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error processing WebRTC call page", (Throwable)e);
                                httpRes.setStatus(500);
                                httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                            }
                        } else {
                            httpRes.setStatus(401);
                            httpReq.getRequestDispatcher(UNAUTHORIZED_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                        }
                    } else {
                        LOG.error((Object)("WebRTC provider not found for call page and user " + remoteUser));
                        httpRes.setStatus(500);
                        httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                    }
                } else {
                    LOG.error((Object)("Web Conferencing service not found for call page and user " + remoteUser));
                    httpRes.setStatus(500);
                    httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

